/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.IntCollection;
import net.openhft.collect.IntCursor;
import net.openhft.collect.IntIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractIntValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonIntIntMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalIntIntMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.ImmutableLHashParallelKVIntIntMapSO;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.ParallelKVIntIntLHash;
import net.openhft.collect.map.IntIntCursor;
import net.openhft.collect.set.IntSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.IntIntConsumer;
import net.openhft.function.IntIntPredicate;
import net.openhft.function.IntIntToIntFunction;

public class ImmutableLHashParallelKVIntIntMapGO
extends ImmutableLHashParallelKVIntIntMapSO {
    final void copy(ParallelKVIntIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVIntIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(int key, int value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix(key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (int)(entry >>> 32) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix(k) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
            return null;
        }
        return null;
    }

    public int get(int key) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix(key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    @Override
    public Integer getOrDefault(Object key, Integer defaultValue) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix(k) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public int getOrDefault(int key, int defaultValue) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix(key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept((Integer)key, (Integer)((int)(entry >>> 32)));
        }
    }

    public void forEach(IntIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept(key, (int)(entry >>> 32));
        }
    }

    public boolean forEachWhile(IntIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || predicate.test(key, (int)(entry >>> 32))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public IntIntCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntIntMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalIntIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalIntIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Integer, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((int)(entry >>> 32));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Integer put(Integer key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int put(int key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer putIfAbsent(Integer key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putIfAbsent(int key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(int key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer compute(Integer key, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int compute(int key, IntIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer computeIfAbsent(Integer key, Function<? super Integer, ? extends Integer> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer computeIfPresent(Integer key, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfPresent(int key, IntIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer merge(Integer key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int merge(int key, int value, IntBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int addValue(int key, int value) {
        throw new UnsupportedOperationException();
    }

    public int addValue(int key, int addition, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Integer, ? extends Integer> m) {
        CommonIntIntMapOps.putAll(this, m);
    }

    @Override
    public Integer replace(Integer key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int replace(int key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Integer key, Integer oldValue, Integer newValue) {
        return this.replace((int)key, (int)oldValue, (int)newValue);
    }

    @Override
    public boolean replace(int key, int oldValue, int newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Integer, ? extends Integer> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(IntIntToIntFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public int remove(int key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, (Integer)value);
    }

    public boolean remove(int key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(IntIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements IntIntCursor {
        final long[] tab;
        final int free;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor() {
            int free;
            this.tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue);
        }

        public void forEachForward(IntIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key, (int)(entry >>> 32));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), value);
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final long[] tab;
        final int free;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor() {
            int free;
            this.tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue);
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((int)(entry >>> 32));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final long[] tab;
        final int free;
        int nextIndex;
        int next;

        NoRemovedValueIterator() {
            this.tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            int free = this.free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry == free) continue;
                this.next = (int)(entry >>> 32);
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                int free = this.free;
                int prev = this.next;
                while (--nextI >= 0) {
                    long entry = tab[nextI];
                    if ((int)entry == free) continue;
                    this.next = (int)(entry >>> 32);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((int)(entry >>> 32));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Integer>> {
        final long[] tab;
        final int free;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor() {
            int free;
            this.tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, (int)(entry >>> 32)));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Integer> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Integer>> {
        final long[] tab;
        final int free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            int free = this.free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free) continue;
                this.next = new ImmutableEntry(key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, (int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                int free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    long entry = tab[nextI];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, (int)(entry >>> 32));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVIntIntMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVIntIntMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashParallelKVIntIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return ImmutableLHashParallelKVIntIntMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((int)(entry >>> 32));
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || predicate.test((int)(entry >>> 32))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= s.removeInt((int)(entry >>> 32));
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public IntCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                sb.append(' ').append((int)(entry >>> 32)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return ImmutableLHashParallelKVIntIntMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVIntIntMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends IntIntEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends IntIntEntry {
        private final int key;
        private final int value;

        ImmutableEntry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class IntIntEntry
    extends AbstractEntry<Integer, Integer> {
        IntIntEntry() {
        }

        abstract int key();

        @Override
        public final Integer getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Integer getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Integer>>
    implements HashObjSet<Map.Entry<Integer, Integer>>,
    InternalObjCollectionOps<Map.Entry<Integer, Integer>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Integer, Integer>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashParallelKVIntIntMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVIntIntMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashParallelKVIntIntMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashParallelKVIntIntMapGO.this.containsEntry((Integer)e.getKey(), (Integer)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, (int)(entry >>> 32));
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, (int)(entry >>> 32));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, (int)(entry >>> 32)));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || predicate.test(new ImmutableEntry(key, (int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Integer, Integer>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Integer>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, (int)(entry >>> 32)));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashParallelKVIntIntMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((int)(entry >>> 32));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVIntIntMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                int value = (Integer)e.getValue();
                return ImmutableLHashParallelKVIntIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVIntIntMapGO.this.clear();
        }
    }
}

