/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalObjFloatMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.map.ObjFloatMap;
import net.openhft.function.ObjFloatConsumer;
import net.openhft.function.ObjFloatPredicate;

public final class CommonObjFloatMapOps {
    public static boolean containsAllEntries(final InternalObjFloatMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjFloatMap) {
            ObjFloatMap m2 = (ObjFloatMap)another;
            if (NullableObjects.equals(m2.keyEquivalence(), map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjFloatMapOps) {
                    return ((InternalObjFloatMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjFloatPredicate(){

                public boolean test(Object a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjFloatMapOps<K> map, Map<? extends K, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjFloatMap) {
            if (another instanceof InternalObjFloatMapOps) {
                ((InternalObjFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjFloatMap)another).forEach(new ObjFloatConsumer<K>(){

                    public void accept(K key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Float> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().floatValue());
            }
        }
    }

    private CommonObjFloatMapOps() {
    }
}

