/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalIntDoubleMapOps;
import net.openhft.collect.map.IntDoubleMap;
import net.openhft.function.IntDoubleConsumer;
import net.openhft.function.IntDoublePredicate;

public final class CommonIntDoubleMapOps {
    public static boolean containsAllEntries(final InternalIntDoubleMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntDoubleMap) {
            IntDoubleMap m2 = (IntDoubleMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalIntDoubleMapOps) {
                return ((InternalIntDoubleMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new IntDoublePredicate(){

                public boolean test(int a, double b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((int)((Integer)e.getKey()), (Double)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalIntDoubleMapOps map, Map<? extends Integer, ? extends Double> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntDoubleMap) {
            if (another instanceof InternalIntDoubleMapOps) {
                ((InternalIntDoubleMapOps)another).reversePutAllTo(map);
            } else {
                ((IntDoubleMap)another).forEach(new IntDoubleConsumer(){

                    public void accept(int key, double value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Integer, ? extends Double> e : another.entrySet()) {
                map.justPut((int)e.getKey(), e.getValue());
            }
        }
    }

    private CommonIntDoubleMapOps() {
    }
}

