/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalFloatLongMapOps;
import net.openhft.collect.map.FloatLongMap;
import net.openhft.function.FloatLongConsumer;
import net.openhft.function.FloatLongPredicate;

public final class CommonFloatLongMapOps {
    public static boolean containsAllEntries(final InternalFloatLongMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof FloatLongMap) {
            FloatLongMap m2 = (FloatLongMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalFloatLongMapOps) {
                return ((InternalFloatLongMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new FloatLongPredicate(){

                public boolean test(float a, long b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Float)e.getKey()).floatValue(), (long)((Long)e.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalFloatLongMapOps map, Map<? extends Float, ? extends Long> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof FloatLongMap) {
            if (another instanceof InternalFloatLongMapOps) {
                ((InternalFloatLongMapOps)another).reversePutAllTo(map);
            } else {
                ((FloatLongMap)another).forEach(new FloatLongConsumer(){

                    public void accept(float key, long value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Float, ? extends Long> e : another.entrySet()) {
                map.justPut(e.getKey().floatValue(), (long)e.getValue());
            }
        }
    }

    private CommonFloatLongMapOps() {
    }
}

