/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalCharCharMapOps;
import net.openhft.collect.map.CharCharMap;
import net.openhft.function.CharCharConsumer;
import net.openhft.function.CharCharPredicate;

public final class CommonCharCharMapOps {
    public static boolean containsAllEntries(final InternalCharCharMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof CharCharMap) {
            CharCharMap m2 = (CharCharMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalCharCharMapOps) {
                return ((InternalCharCharMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new CharCharPredicate(){

                public boolean test(char a, char b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Character)e.getKey()).charValue(), ((Character)e.getValue()).charValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalCharCharMapOps map, Map<? extends Character, ? extends Character> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof CharCharMap) {
            if (another instanceof InternalCharCharMapOps) {
                ((InternalCharCharMapOps)another).reversePutAllTo(map);
            } else {
                ((CharCharMap)another).forEach(new CharCharConsumer(){

                    public void accept(char key, char value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Character, ? extends Character> e : another.entrySet()) {
                map.justPut(e.getKey().charValue(), e.getValue().charValue());
            }
        }
    }

    private CommonCharCharMapOps() {
    }
}

