/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalByteShortMapOps;
import net.openhft.collect.map.ByteShortMap;
import net.openhft.function.ByteShortConsumer;
import net.openhft.function.ByteShortPredicate;

public final class CommonByteShortMapOps {
    public static boolean containsAllEntries(final InternalByteShortMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ByteShortMap) {
            ByteShortMap m2 = (ByteShortMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalByteShortMapOps) {
                return ((InternalByteShortMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ByteShortPredicate(){

                public boolean test(byte a, short b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Byte)e.getKey(), (Short)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalByteShortMapOps map, Map<? extends Byte, ? extends Short> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteShortMap) {
            if (another instanceof InternalByteShortMapOps) {
                ((InternalByteShortMapOps)another).reversePutAllTo(map);
            } else {
                ((ByteShortMap)another).forEach(new ByteShortConsumer(){

                    public void accept(byte key, short value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Byte, ? extends Short> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonByteShortMapOps() {
    }
}

