/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl;

import java.util.Map;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.InternalByteObjMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.map.ByteObjMap;
import net.openhft.function.ByteObjConsumer;
import net.openhft.function.ByteObjPredicate;

public final class CommonByteObjMapOps {
    public static boolean containsAllEntries(final InternalByteObjMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ByteObjMap) {
            ByteObjMap m2 = (ByteObjMap)another;
            if (NullableObjects.equals(m2.valueEquivalence(), map.valueEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalByteObjMapOps) {
                    return ((InternalByteObjMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ByteObjPredicate(){

                public boolean test(byte a, Object b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Byte)e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <V> void putAll(final InternalByteObjMapOps<V> map, Map<? extends Byte, ? extends V> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteObjMap) {
            if (another instanceof InternalByteObjMapOps) {
                ((InternalByteObjMapOps)another).reversePutAllTo(map);
            } else {
                ((ByteObjMap)another).forEach(new ByteObjConsumer<V>(){

                    public void accept(byte key, V value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<Byte, V> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonByteObjMapOps() {
    }
}

