/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.impl.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.collect.map.hash.*;
import javax.annotation.Nullable;

import static net.openhft.collect.impl.hash.LHashCapacities.configIsSuitableForMutableLHash;


public final class QHashSeparateKVDoubleObjMapFactoryImpl<V>
        extends QHashSeparateKVDoubleObjMapFactoryGO<V> {

    

    

    
    
    

    
    
    

    /** For ServiceLoader */
    public QHashSeparateKVDoubleObjMapFactoryImpl() {
        this(HashConfig.getDefault(), 10
            );
    }

    

    

    

    QHashSeparateKVDoubleObjMapFactoryImpl(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    @Override
    HashDoubleObjMapFactory<V> thisWith(HashConfig hashConf, int defaultExpectedSize) {
        return new QHashSeparateKVDoubleObjMapFactoryImpl<V>(hashConf, defaultExpectedSize);
    }

    @Override
    HashDoubleObjMapFactory<V> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize) {
        return new QHashSeparateKVDoubleObjMapFactoryImpl<V>(hashConf, defaultExpectedSize);
    }
    @Override
    HashDoubleObjMapFactory<V> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize) {
        return new LHashSeparateKVDoubleObjMapFactoryImpl<V>(hashConf, defaultExpectedSize);
    }


    @Override
    public <VE> HashDoubleObjMapFactory<VE> withValueEquivalence(
            @Nullable Equivalence<VE> valueEquivalence) {
        if (valueEquivalence == null) {
            // noinspection unchecked
            return (HashDoubleObjMapFactory<VE>) this;
        }
        return new WithCustomValueEquivalence<VE>(getHashConfig(), getDefaultExpectedSize()
        , valueEquivalence);
    }


    static final class WithCustomValueEquivalence<V>
            extends QHashSeparateKVDoubleObjMapFactoryGO<V> {

        private final Equivalence<V> valueEquivalence;
        WithCustomValueEquivalence(HashConfig hashConf, int defaultExpectedSize,
                Equivalence<V> valueEquivalence) {
            super(hashConf, defaultExpectedSize);
            this.valueEquivalence = valueEquivalence;
        }

        @Override
        public Equivalence<V> getValueEquivalence() {
            return valueEquivalence;
        }

        @Override
        <V2 extends V> MutableQHashSeparateKVDoubleObjMapGO<V2>
        uninitializedMutableMap() {
            MutableQHashSeparateKVDoubleObjMap.WithCustomValueEquivalence<V2> map =
                    new MutableQHashSeparateKVDoubleObjMap.WithCustomValueEquivalence<V2>();
            map.valueEquivalence = valueEquivalence;
            return map;
        }
        @Override
        <V2 extends V> UpdatableQHashSeparateKVDoubleObjMapGO<V2>
        uninitializedUpdatableMap() {
            UpdatableQHashSeparateKVDoubleObjMap.WithCustomValueEquivalence<V2> map =
                    new UpdatableQHashSeparateKVDoubleObjMap.WithCustomValueEquivalence<V2>();
            map.valueEquivalence = valueEquivalence;
            return map;
        }
        @Override
        <V2 extends V> ImmutableQHashSeparateKVDoubleObjMapGO<V2>
        uninitializedImmutableMap() {
            ImmutableQHashSeparateKVDoubleObjMap.WithCustomValueEquivalence<V2> map =
                    new ImmutableQHashSeparateKVDoubleObjMap.WithCustomValueEquivalence<V2>();
            map.valueEquivalence = valueEquivalence;
            return map;
        }


        @Override
        public <VE> HashDoubleObjMapFactory<VE> withValueEquivalence(
                @Nullable Equivalence<VE> valueEquivalence) {
            if (valueEquivalence == null)
                return new QHashSeparateKVDoubleObjMapFactoryImpl<VE>(getHashConfig(), getDefaultExpectedSize()
        );
            if (valueEquivalence.equals(this.valueEquivalence))
                // noinspection unchecked
                return (HashDoubleObjMapFactory<VE>) this;
            return new WithCustomValueEquivalence<VE>(getHashConfig(), getDefaultExpectedSize()
        , valueEquivalence);
        }

        @Override
        HashDoubleObjMapFactory<V> thisWith(HashConfig hashConf, int defaultExpectedSize) {
            return new WithCustomValueEquivalence<V>(hashConf, defaultExpectedSize,
                    valueEquivalence);
        }

        @Override
        HashDoubleObjMapFactory<V> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize) {
            return new QHashSeparateKVDoubleObjMapFactoryImpl.WithCustomValueEquivalence<V>(
                    hashConf, defaultExpectedSize, valueEquivalence);
        }
        @Override
        HashDoubleObjMapFactory<V> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize) {
            return new LHashSeparateKVDoubleObjMapFactoryImpl.WithCustomValueEquivalence<V>(
                    hashConf, defaultExpectedSize, valueEquivalence);
        }
    }

}

