/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.impl.hash;

import net.openhft.collect.hash.*;
import net.openhft.collect.map.CharShortMap;
import net.openhft.collect.map.hash.HashCharShortMapFactory;

import java.util.Map;


public abstract class QHashParallelKVCharShortMapFactorySO
        extends CharQHashFactory 
                        <MutableQHashParallelKVCharShortMapGO>
        implements HashCharShortMapFactory {

    QHashParallelKVCharShortMapFactorySO(HashConfig hashConf, int defaultExpectedSize
            , char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    

    

    

    @Override
    MutableQHashParallelKVCharShortMapGO createNewMutable(
            int expectedSize, char free, char removed) {
        MutableQHashParallelKVCharShortMapGO map = uninitializedMutableMap();
        map.init(configWrapper, expectedSize, free, removed);
        return map;
    }

     MutableQHashParallelKVCharShortMapGO uninitializedMutableMap() {
        return new MutableQHashParallelKVCharShortMap();
    }
     UpdatableQHashParallelKVCharShortMapGO uninitializedUpdatableMap() {
        return new UpdatableQHashParallelKVCharShortMap();
    }
     ImmutableQHashParallelKVCharShortMapGO uninitializedImmutableMap() {
        return new ImmutableQHashParallelKVCharShortMap();
    }

    @Override
    public  MutableQHashParallelKVCharShortMapGO newMutableMap(int expectedSize) {
        // noinspection unchecked
        return (MutableQHashParallelKVCharShortMapGO) newMutableHash(expectedSize);
    }

    

    @Override
    public  UpdatableQHashParallelKVCharShortMapGO newUpdatableMap(int expectedSize) {
        UpdatableQHashParallelKVCharShortMapGO map = uninitializedUpdatableMap();
        map.init(configWrapper, expectedSize, getFree());
        return map;
    }

    

    @Override
    public  UpdatableQHashParallelKVCharShortMapGO newUpdatableMap(
            Map<Character, Short> map) {
        if (map instanceof CharShortMap) {
            if (map instanceof ParallelKVCharShortQHash) {
                ParallelKVCharShortQHash hash = (ParallelKVCharShortQHash) map;
                if (hash.hashConfig().equals(hashConf)) {
                    UpdatableQHashParallelKVCharShortMapGO res = uninitializedUpdatableMap();
                    res.copy(hash);
                    return res;
                }
            }
            UpdatableQHashParallelKVCharShortMapGO res = newUpdatableMap(map.size());
            res.putAll(map);
            return res;
        }
        UpdatableQHashParallelKVCharShortMapGO res = newUpdatableMap(map.size());
        for (Map.Entry<Character, Short> entry : map.entrySet()) {
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }
}

