/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.impl.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.HashConfig;
import net.openhft.function.ShortConsumer;
import net.openhft.function.ShortPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.collect.impl.*;
import net.openhft.collect.set.ShortSet;
import net.openhft.collect.set.hash.HashShortSet;
import javax.annotation.Nonnull;

import java.util.*;


public abstract class MutableQHashParallelKVShortKeyMap
        extends MutableParallelKVShortQHashGO {



    public final boolean containsKey(Object key) {
        return contains(key);
    }

    public boolean containsKey(short key) {
        return contains(key);
    }


    @Nonnull
    public HashShortSet keySet() {
        return new KeyView();
    }


    abstract boolean justRemove(short key);


    class KeyView extends AbstractShortKeyView
            implements HashShortSet, InternalShortCollectionOps, ParallelKVShortQHash {


        @Nonnull
        @Override
        public HashConfig hashConfig() {
            return MutableQHashParallelKVShortKeyMap.this.hashConfig();
        }

        @Override
        public HashConfigWrapper configWrapper() {
            return MutableQHashParallelKVShortKeyMap.this.configWrapper();
        }

        @Override
        public int size() {
            return MutableQHashParallelKVShortKeyMap.this.size();
        }

        @Override
        public double currentLoad() {
            return MutableQHashParallelKVShortKeyMap.this.currentLoad();
        }

        @Override
        public short freeValue() {
            return MutableQHashParallelKVShortKeyMap.this.freeValue();
        }

        @Override
        public boolean supportRemoved() {
            return MutableQHashParallelKVShortKeyMap.this.supportRemoved();
        }

        @Override
        public short removedValue() {
            return MutableQHashParallelKVShortKeyMap.this.removedValue();
        }

        @Nonnull
        @Override
        public int[] table() {
            return MutableQHashParallelKVShortKeyMap.this.table();
        }

        @Override
        public int capacity() {
            return MutableQHashParallelKVShortKeyMap.this.capacity();
        }

        @Override
        public int freeSlots() {
            return MutableQHashParallelKVShortKeyMap.this.freeSlots();
        }

        @Override
        public boolean noRemoved() {
            return MutableQHashParallelKVShortKeyMap.this.noRemoved();
        }

        @Override
        public int removedSlots() {
            return MutableQHashParallelKVShortKeyMap.this.removedSlots();
        }

        @Override
        public int modCount() {
            return MutableQHashParallelKVShortKeyMap.this.modCount();
        }

        @Override
        public final boolean contains(Object o) {
            return MutableQHashParallelKVShortKeyMap.this.contains(o);
        }

        @Override
        public boolean contains(short key) {
            return MutableQHashParallelKVShortKeyMap.this.contains(key);
        }



        @Override
        public void forEach(Consumer<? super Short> action) {
            MutableQHashParallelKVShortKeyMap.this.forEach(action);
        }

        @Override
        public void forEach(ShortConsumer action) {
            MutableQHashParallelKVShortKeyMap.this.forEach(action);
        }

        @Override
        public boolean forEachWhile(ShortPredicate
                predicate) {
            return MutableQHashParallelKVShortKeyMap.this.forEachWhile(predicate);
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            return MutableQHashParallelKVShortKeyMap.this.allContainingIn(c);
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            return MutableQHashParallelKVShortKeyMap.this.reverseAddAllTo(c);
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            return MutableQHashParallelKVShortKeyMap.this.reverseRemoveAllFrom(s);
        }

        @Override
        @Nonnull
        public ShortIterator iterator() {
            return MutableQHashParallelKVShortKeyMap.this.iterator();
        }

        @Override
        @Nonnull
        public ShortCursor cursor() {
            return setCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            return MutableQHashParallelKVShortKeyMap.this.toArray();
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            return MutableQHashParallelKVShortKeyMap.this.toArray(a);
        }

        @Override
        public short[] toShortArray() {
            return MutableQHashParallelKVShortKeyMap.this.toShortArray();
        }

        @Override
        public short[] toArray(short[] a) {
            return MutableQHashParallelKVShortKeyMap.this.toArray(a);
        }


        @Override
        public int hashCode() {
            return setHashCode();
        }

        @Override
        public String toString() {
            return setToString();
        }


        @Override
        public boolean shrink() {
            return MutableQHashParallelKVShortKeyMap.this.shrink();
        }


        @Override
        public final boolean remove(Object o) {
            return justRemove((Short) o);
        }

        @Override
        public boolean removeShort(short v) {
            return justRemove(v);
        }



        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            return MutableQHashParallelKVShortKeyMap.this.removeIf(filter);
        }

        @Override
        public boolean removeIf(ShortPredicate filter) {
            return MutableQHashParallelKVShortKeyMap.this.removeIf(filter);
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                if (c instanceof InternalShortCollectionOps) {
                    InternalShortCollectionOps c2 = (InternalShortCollectionOps) c;
                    if (c2.size() < this.size()) {
                        
                        return c2.reverseRemoveAllFrom(this);
                    }
                }
                return MutableQHashParallelKVShortKeyMap.this.removeAll(this, (ShortCollection) c);
            }
            return MutableQHashParallelKVShortKeyMap.this.removeAll(this, c);
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            return MutableQHashParallelKVShortKeyMap.this.retainAll(this, c);
        }

        @Override
        public void clear() {
            MutableQHashParallelKVShortKeyMap.this.clear();
        }
    }
}

