/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.impl.hash;

import net.openhft.collect.hash.*;
import net.openhft.collect.map.IntIntMap;
import net.openhft.collect.map.hash.HashIntIntMapFactory;

import java.util.Map;


public abstract class LHashParallelKVIntIntMapFactorySO
        extends IntLHashFactory 
        implements HashIntIntMapFactory {

    LHashParallelKVIntIntMapFactorySO(HashConfig hashConf, int defaultExpectedSize
            , int lower, int upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    

    

    


     MutableLHashParallelKVIntIntMapGO uninitializedMutableMap() {
        return new MutableLHashParallelKVIntIntMap();
    }
     UpdatableLHashParallelKVIntIntMapGO uninitializedUpdatableMap() {
        return new UpdatableLHashParallelKVIntIntMap();
    }
     ImmutableLHashParallelKVIntIntMapGO uninitializedImmutableMap() {
        return new ImmutableLHashParallelKVIntIntMap();
    }

    @Override
    public  MutableLHashParallelKVIntIntMapGO newMutableMap(int expectedSize) {
        MutableLHashParallelKVIntIntMapGO map = uninitializedMutableMap();
        map.init(configWrapper, expectedSize, getFree());
        return map;
    }

    

    @Override
    public  UpdatableLHashParallelKVIntIntMapGO newUpdatableMap(int expectedSize) {
        UpdatableLHashParallelKVIntIntMapGO map = uninitializedUpdatableMap();
        map.init(configWrapper, expectedSize, getFree());
        return map;
    }

    

    @Override
    public  UpdatableLHashParallelKVIntIntMapGO newUpdatableMap(
            Map<Integer, Integer> map) {
        if (map instanceof IntIntMap) {
            if (map instanceof ParallelKVIntIntLHash) {
                ParallelKVIntIntLHash hash = (ParallelKVIntIntLHash) map;
                if (hash.hashConfig().equals(hashConf)) {
                    UpdatableLHashParallelKVIntIntMapGO res = uninitializedUpdatableMap();
                    res.copy(hash);
                    return res;
                }
            }
            UpdatableLHashParallelKVIntIntMapGO res = newUpdatableMap(map.size());
            res.putAll(map);
            return res;
        }
        UpdatableLHashParallelKVIntIntMapGO res = newUpdatableMap(map.size());
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }
}

