/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.impl.hash;

import net.openhft.collect.Equivalence;
import net.openhft.collect.hash.*;
import net.openhft.collect.set.hash.HashObjSetFactory;
import javax.annotation.Nullable;


public final class LHashObjSetFactoryImpl<E> extends LHashObjSetFactoryGO<E> {

    /** For ServiceLoader */
    public LHashObjSetFactoryImpl() {
        this(HashConfig.getDefault(), 10, false);
    }

    

    

    

    public LHashObjSetFactoryImpl(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        super(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    @Override
    public <E2> HashObjSetFactory<E2> withEquivalence(@Nullable Equivalence<E2> equivalence) {
        if (equivalence == null) {
            // noinspection unchecked
            return (HashObjSetFactory<E2>) this;
        }
        return new WithCustomEquivalence<E2>(getHashConfig(), getDefaultExpectedSize(), isNullKeyAllowed(), equivalence);
    }


    public HashObjSetFactory<E> withNullKeyAllowed(boolean nullAllowed) {
        if (nullAllowed == isNullKeyAllowed())
            return this;
        return thisWith(getHashConfig(), getDefaultExpectedSize(), nullAllowed);
    }

    @Override
    HashObjSetFactory<E> thisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new LHashObjSetFactoryImpl<E>(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    @Override
    HashObjSetFactory<E> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new QHashObjSetFactoryImpl<E>(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }
    @Override
    HashObjSetFactory<E> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new LHashObjSetFactoryImpl<E>(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    static final class WithCustomEquivalence<E> extends LHashObjSetFactoryGO<E> {
        final Equivalence<E> equivalence;

        public WithCustomEquivalence(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed, Equivalence<E> equivalence) {
            super(hashConf, defaultExpectedSize, isNullKeyAllowed);
            this.equivalence = equivalence;
        }

        @Override
        public Equivalence<E> getEquivalence() {
            return equivalence;
        }

        @Override
        <E2 extends E> MutableLHashObjSetGO<E2> uninitializedMutableSet() {
            MutableLHashObjSet.WithCustomEquivalence<E2> set =
                    new MutableLHashObjSet.WithCustomEquivalence<E2>();
            set.equivalence = equivalence;
            return set;
        }
        @Override
        <E2 extends E> UpdatableLHashObjSetGO<E2> uninitializedUpdatableSet() {
            UpdatableLHashObjSet.WithCustomEquivalence<E2> set =
                    new UpdatableLHashObjSet.WithCustomEquivalence<E2>();
            set.equivalence = equivalence;
            return set;
        }
        @Override
        <E2 extends E> ImmutableLHashObjSetGO<E2> uninitializedImmutableSet() {
            ImmutableLHashObjSet.WithCustomEquivalence<E2> set =
                    new ImmutableLHashObjSet.WithCustomEquivalence<E2>();
            set.equivalence = equivalence;
            return set;
        }

        @Override
        public <E2> HashObjSetFactory<E2> withEquivalence(@Nullable Equivalence<E2> equivalence) {
            if (equivalence == null)
                return new LHashObjSetFactoryImpl<E2>(getHashConfig(), getDefaultExpectedSize(), isNullKeyAllowed());
            if (this.equivalence.equals(equivalence)) {
                // noinspection unchecked
                return (HashObjSetFactory<E2>) this;
            }
            return new WithCustomEquivalence<E2>(getHashConfig(), getDefaultExpectedSize(), isNullKeyAllowed(), equivalence);
        }

        @Override
        public HashObjSetFactory<E> withNullKeyAllowed(boolean nullAllowed) {
            if (nullAllowed == isNullKeyAllowed())
                return this;
            return thisWith(getHashConfig(), getDefaultExpectedSize(), nullAllowed);
        }

        @Override
        HashObjSetFactory<E> thisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, equivalence);
        }

        @Override
        HashObjSetFactory<E> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new QHashObjSetFactoryImpl.WithCustomEquivalence<E>(
                hashConf, defaultExpectedSize, isNullKeyAllowed, equivalence);
        }
        @Override
        HashObjSetFactory<E> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new LHashObjSetFactoryImpl.WithCustomEquivalence<E>(
                hashConf, defaultExpectedSize, isNullKeyAllowed, equivalence);
        }
    }
}

