/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.impl.hash;

import net.openhft.collect.Equivalence;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;


final class ImmutableLHashSeparateKVShortObjMap<V>
        extends ImmutableLHashSeparateKVShortObjMapGO<V> {

    


    
    static final class WithCustomValueEquivalence<V>
            extends ImmutableLHashSeparateKVShortObjMapGO<V> {
        Equivalence<? super V> valueEquivalence;

        

        @Override
        public Equivalence<V> valueEquivalence() {
            // noinspection unchecked
            return (Equivalence<V>) valueEquivalence;
        }

        @Override
        boolean nullableValueEquals(@Nullable V a, @Nullable V b) {
            return valueEquivalence.nullableEquivalent(a, b);
        }

        @Override
        boolean valueEquals(@Nonnull V a, @Nullable V b) {
            return b != null && valueEquivalence.equivalent(a, b);
        }

        @Override
        int nullableValueHashCode(@Nullable V value) {
            return valueEquivalence.nullableHash(value);
        }

        @Override
        int valueHashCode(@Nonnull V value) {
            return valueEquivalence.hash(value);
        }
    }


}

