/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.function.ShortConsumer;

import java.util.Iterator;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashShortSet}s, and
 * the default {@link HashShortSetFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashShortSet
 */
public final class HashShortSets {
    private static final ServiceLoader<HashShortSetFactory> LOADER =
            ServiceLoader.load(HashShortSetFactory.class);
    private static HashShortSetFactory defaultFactory = null;

    public static HashShortSetFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }
    
    

    public static  HashShortSet newMutableSet() {
        return getDefaultFactory().newMutableSet();
    }

    public static  HashShortSet newMutableSet(int expectedSize) {
        return getDefaultFactory().newMutableSet(expectedSize);
    }



    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashShortSet newMutableSet(
            Iterable<Short> elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, expectedSize);
    }

    public static  HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashShortSet newMutableSet(
            Iterable<Short> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2) {
        return getDefaultFactory().newMutableSet(elems1, elems2);
    }

    public static  HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3);
    }

    public static  HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashShortSet newMutableSet(Iterator<Short> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashShortSet newMutableSet(Iterator<Short> elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashShortSet newMutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier) {
        return getDefaultFactory().newMutableSet(elementsSupplier);
    }

    public static  HashShortSet newMutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elementsSupplier, expectedSize);
    }

    public static  HashShortSet newMutableSet(short[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashShortSet newMutableSet(short[] elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }
    
    public static HashShortSet newMutableSet(Short[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static HashShortSet newMutableSet(Short[] elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashShortSet newMutableSetOf(short e1) {
        return getDefaultFactory().newMutableSetOf(e1);
    }

    public static  HashShortSet newMutableSetOf(short e1, short e2) {
        return getDefaultFactory().newMutableSetOf(e1, e2);
    }

    public static  HashShortSet newMutableSetOf(short e1, short e2, short e3) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3);
    }

    public static  HashShortSet newMutableSetOf(short e1, short e2, short e3, short e4) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4);
    }

    public static  HashShortSet newMutableSetOf(short e1, short e2, short e3, short e4,
            short e5, short... restElements) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashShortSet newUpdatableSet(
            Iterable<Short> elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, expectedSize);
    }

    public static  HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashShortSet newUpdatableSet(
            Iterable<Short> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2);
    }

    public static  HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3);
    }

    public static  HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashShortSet newUpdatableSet(Iterator<Short> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashShortSet newUpdatableSet(Iterator<Short> elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashShortSet newUpdatableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier);
    }

    public static  HashShortSet newUpdatableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier, expectedSize);
    }

    public static  HashShortSet newUpdatableSet(short[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashShortSet newUpdatableSet(short[] elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }
    
    public static HashShortSet newUpdatableSet(Short[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static HashShortSet newUpdatableSet(Short[] elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashShortSet newUpdatableSetOf(short e1) {
        return getDefaultFactory().newUpdatableSetOf(e1);
    }

    public static  HashShortSet newUpdatableSetOf(short e1, short e2) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2);
    }

    public static  HashShortSet newUpdatableSetOf(short e1, short e2, short e3) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3);
    }

    public static  HashShortSet newUpdatableSetOf(short e1, short e2, short e3, short e4) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4);
    }

    public static  HashShortSet newUpdatableSetOf(short e1, short e2, short e3, short e4,
            short e5, short... restElements) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashShortSet newImmutableSet(
            Iterable<Short> elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, expectedSize);
    }

    public static  HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashShortSet newImmutableSet(
            Iterable<Short> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2) {
        return getDefaultFactory().newImmutableSet(elems1, elems2);
    }

    public static  HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3);
    }

    public static  HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashShortSet newImmutableSet(Iterator<Short> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashShortSet newImmutableSet(Iterator<Short> elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashShortSet newImmutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier) {
        return getDefaultFactory().newImmutableSet(elementsSupplier);
    }

    public static  HashShortSet newImmutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elementsSupplier, expectedSize);
    }

    public static  HashShortSet newImmutableSet(short[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashShortSet newImmutableSet(short[] elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }
    
    public static HashShortSet newImmutableSet(Short[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static HashShortSet newImmutableSet(Short[] elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashShortSet newImmutableSetOf(short e1) {
        return getDefaultFactory().newImmutableSetOf(e1);
    }

    public static  HashShortSet newImmutableSetOf(short e1, short e2) {
        return getDefaultFactory().newImmutableSetOf(e1, e2);
    }

    public static  HashShortSet newImmutableSetOf(short e1, short e2, short e3) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3);
    }

    public static  HashShortSet newImmutableSetOf(short e1, short e2, short e3, short e4) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4);
    }

    public static  HashShortSet newImmutableSetOf(short e1, short e2, short e3, short e4,
            short e5, short... restElements) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    private HashShortSets() {}
}

