/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ShortConsumer;
import net.openhft.collect.set.ShortSetFactory;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashShortSet}s.
 *
 * @see HashShortSet
 * @see HashShortSets#getDefaultFactory()
 */
public interface HashShortSetFactory extends ShortSetFactory
        , ShortHashFactory<HashShortSetFactory>
         {


    

    

    

    @Override
     HashShortSet newMutableSet();

    @Override
     HashShortSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashShortSet newMutableSet(Iterable<Short> elements, int expectedSize);

    @Override
     HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, int expectedSize);

    @Override
     HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize);

    @Override
     HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, int expectedSize);

    @Override
     HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize);

    

    
    @Override
     HashShortSet newMutableSet(Iterable<Short> elements);

    @Override
     HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2);

    @Override
     HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3);

    @Override
     HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4);

    @Override
     HashShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5);


    @Override
     HashShortSet newMutableSet(Iterator<Short> elements);

    @Override
     HashShortSet newMutableSet(Iterator<Short> elements,
            int expectedSize);

    @Override
     HashShortSet newMutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier);

    @Override
     HashShortSet newMutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashShortSet newMutableSet(short[] elements);

    @Override
     HashShortSet newMutableSet(short[] elements, int expectedSize);

    @Override
     HashShortSet newMutableSet(Short[] elements);

    @Override
     HashShortSet newMutableSet(Short[] elements, int expectedSize);

    @Override
     HashShortSet newMutableSetOf(short e1);

    @Override
     HashShortSet newMutableSetOf(short e1, short e2);

    @Override
     HashShortSet newMutableSetOf(short e1, short e2,
            short e3);

    @Override
     HashShortSet newMutableSetOf(short e1, short e2,
            short e3, short e4);

    @Override
     HashShortSet newMutableSetOf(short e1, short e2,
            short e3, short e4, short e5,
            short... restElements);
    @Override
     HashShortSet newUpdatableSet();

    @Override
     HashShortSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elements, int expectedSize);

    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, int expectedSize);

    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize);

    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, int expectedSize);

    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize);

    

    
    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elements);

    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2);

    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3);

    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4);

    @Override
     HashShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5);


    @Override
     HashShortSet newUpdatableSet(Iterator<Short> elements);

    @Override
     HashShortSet newUpdatableSet(Iterator<Short> elements,
            int expectedSize);

    @Override
     HashShortSet newUpdatableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier);

    @Override
     HashShortSet newUpdatableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashShortSet newUpdatableSet(short[] elements);

    @Override
     HashShortSet newUpdatableSet(short[] elements, int expectedSize);

    @Override
     HashShortSet newUpdatableSet(Short[] elements);

    @Override
     HashShortSet newUpdatableSet(Short[] elements, int expectedSize);

    @Override
     HashShortSet newUpdatableSetOf(short e1);

    @Override
     HashShortSet newUpdatableSetOf(short e1, short e2);

    @Override
     HashShortSet newUpdatableSetOf(short e1, short e2,
            short e3);

    @Override
     HashShortSet newUpdatableSetOf(short e1, short e2,
            short e3, short e4);

    @Override
     HashShortSet newUpdatableSetOf(short e1, short e2,
            short e3, short e4, short e5,
            short... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashShortSet newImmutableSet(Iterable<Short> elements, int expectedSize);

    @Override
     HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, int expectedSize);

    @Override
     HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize);

    @Override
     HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, int expectedSize);

    @Override
     HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize);

    

    
    @Override
     HashShortSet newImmutableSet(Iterable<Short> elements);

    @Override
     HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2);

    @Override
     HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3);

    @Override
     HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4);

    @Override
     HashShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5);


    @Override
     HashShortSet newImmutableSet(Iterator<Short> elements);

    @Override
     HashShortSet newImmutableSet(Iterator<Short> elements,
            int expectedSize);

    @Override
     HashShortSet newImmutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier);

    @Override
     HashShortSet newImmutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashShortSet newImmutableSet(short[] elements);

    @Override
     HashShortSet newImmutableSet(short[] elements, int expectedSize);

    @Override
     HashShortSet newImmutableSet(Short[] elements);

    @Override
     HashShortSet newImmutableSet(Short[] elements, int expectedSize);

    @Override
     HashShortSet newImmutableSetOf(short e1);

    @Override
     HashShortSet newImmutableSetOf(short e1, short e2);

    @Override
     HashShortSet newImmutableSetOf(short e1, short e2,
            short e3);

    @Override
     HashShortSet newImmutableSetOf(short e1, short e2,
            short e3, short e4);

    @Override
     HashShortSet newImmutableSetOf(short e1, short e2,
            short e3, short e4, short e5,
            short... restElements);
}

