/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.function.Consumer;

import java.util.Iterator;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashObjSet}s, and
 * the default {@link HashObjSetFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashObjSet
 */
public final class HashObjSets {
    private static final ServiceLoader<HashObjSetFactory> LOADER =
            ServiceLoader.load(HashObjSetFactory.class);
    private static HashObjSetFactory<Object> defaultFactory = null;

    public static HashObjSetFactory<Object> getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }
    
    

    public static <E> HashObjSet<E> newMutableSet() {
        return getDefaultFactory().newMutableSet();
    }

    public static <E> HashObjSet<E> newMutableSet(int expectedSize) {
        return getDefaultFactory().newMutableSet(expectedSize);
    }



    
    

    /**
     * If the specified elements is a set
     * and has the same equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    public static <E> HashObjSet<E> newMutableSet(
            Iterable<? extends E> elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static <E> HashObjSet<E> newMutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, expectedSize);
    }

    public static <E> HashObjSet<E> newMutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static <E> HashObjSet<E> newMutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static <E> HashObjSet<E> newMutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4, Iterable<? extends E> elems5, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static <E> HashObjSet<E> newMutableSet(
            Iterable<? extends E> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static <E> HashObjSet<E> newMutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2) {
        return getDefaultFactory().newMutableSet(elems1, elems2);
    }

    public static <E> HashObjSet<E> newMutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3);
    }

    public static <E> HashObjSet<E> newMutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4);
    }

    public static <E> HashObjSet<E> newMutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4, Iterable<? extends E> elems5) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static <E> HashObjSet<E> newMutableSet(Iterator<? extends E> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static <E> HashObjSet<E> newMutableSet(Iterator<? extends E> elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static <E> HashObjSet<E> newMutableSet(
            net.openhft.function.Consumer<Consumer<E>> elementsSupplier) {
        return getDefaultFactory().newMutableSet(elementsSupplier);
    }

    public static <E> HashObjSet<E> newMutableSet(
            net.openhft.function.Consumer<Consumer<E>> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elementsSupplier, expectedSize);
    }

    public static <E> HashObjSet<E> newMutableSet(E[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static <E> HashObjSet<E> newMutableSet(E[] elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }
    

    public static <E> HashObjSet<E> newMutableSetOf(E e1) {
        return getDefaultFactory().newMutableSetOf(e1);
    }

    public static <E> HashObjSet<E> newMutableSetOf(E e1, E e2) {
        return getDefaultFactory().newMutableSetOf(e1, e2);
    }

    public static <E> HashObjSet<E> newMutableSetOf(E e1, E e2, E e3) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3);
    }

    public static <E> HashObjSet<E> newMutableSetOf(E e1, E e2, E e3, E e4) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4);
    }

    public static <E> HashObjSet<E> newMutableSetOf(E e1, E e2, E e3, E e4,
            E e5, E... restElements) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set
     * and has the same equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    public static <E> HashObjSet<E> newUpdatableSet(
            Iterable<? extends E> elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static <E> HashObjSet<E> newUpdatableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, expectedSize);
    }

    public static <E> HashObjSet<E> newUpdatableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, expectedSize);
    }

    public static <E> HashObjSet<E> newUpdatableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static <E> HashObjSet<E> newUpdatableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4, Iterable<? extends E> elems5, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static <E> HashObjSet<E> newUpdatableSet(
            Iterable<? extends E> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static <E> HashObjSet<E> newUpdatableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2);
    }

    public static <E> HashObjSet<E> newUpdatableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3);
    }

    public static <E> HashObjSet<E> newUpdatableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4);
    }

    public static <E> HashObjSet<E> newUpdatableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4, Iterable<? extends E> elems5) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static <E> HashObjSet<E> newUpdatableSet(Iterator<? extends E> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static <E> HashObjSet<E> newUpdatableSet(Iterator<? extends E> elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static <E> HashObjSet<E> newUpdatableSet(
            net.openhft.function.Consumer<Consumer<E>> elementsSupplier) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier);
    }

    public static <E> HashObjSet<E> newUpdatableSet(
            net.openhft.function.Consumer<Consumer<E>> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier, expectedSize);
    }

    public static <E> HashObjSet<E> newUpdatableSet(E[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static <E> HashObjSet<E> newUpdatableSet(E[] elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }
    

    public static <E> HashObjSet<E> newUpdatableSetOf(E e1) {
        return getDefaultFactory().newUpdatableSetOf(e1);
    }

    public static <E> HashObjSet<E> newUpdatableSetOf(E e1, E e2) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2);
    }

    public static <E> HashObjSet<E> newUpdatableSetOf(E e1, E e2, E e3) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3);
    }

    public static <E> HashObjSet<E> newUpdatableSetOf(E e1, E e2, E e3, E e4) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4);
    }

    public static <E> HashObjSet<E> newUpdatableSetOf(E e1, E e2, E e3, E e4,
            E e5, E... restElements) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set
     * and has the same equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    public static <E> HashObjSet<E> newImmutableSet(
            Iterable<? extends E> elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static <E> HashObjSet<E> newImmutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, expectedSize);
    }

    public static <E> HashObjSet<E> newImmutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static <E> HashObjSet<E> newImmutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static <E> HashObjSet<E> newImmutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4, Iterable<? extends E> elems5, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static <E> HashObjSet<E> newImmutableSet(
            Iterable<? extends E> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static <E> HashObjSet<E> newImmutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2) {
        return getDefaultFactory().newImmutableSet(elems1, elems2);
    }

    public static <E> HashObjSet<E> newImmutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3);
    }

    public static <E> HashObjSet<E> newImmutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4);
    }

    public static <E> HashObjSet<E> newImmutableSet(Iterable<? extends E> elems1,
            Iterable<? extends E> elems2, Iterable<? extends E> elems3,
            Iterable<? extends E> elems4, Iterable<? extends E> elems5) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static <E> HashObjSet<E> newImmutableSet(Iterator<? extends E> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static <E> HashObjSet<E> newImmutableSet(Iterator<? extends E> elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static <E> HashObjSet<E> newImmutableSet(
            net.openhft.function.Consumer<Consumer<E>> elementsSupplier) {
        return getDefaultFactory().newImmutableSet(elementsSupplier);
    }

    public static <E> HashObjSet<E> newImmutableSet(
            net.openhft.function.Consumer<Consumer<E>> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elementsSupplier, expectedSize);
    }

    public static <E> HashObjSet<E> newImmutableSet(E[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static <E> HashObjSet<E> newImmutableSet(E[] elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }
    

    public static <E> HashObjSet<E> newImmutableSetOf(E e1) {
        return getDefaultFactory().newImmutableSetOf(e1);
    }

    public static <E> HashObjSet<E> newImmutableSetOf(E e1, E e2) {
        return getDefaultFactory().newImmutableSetOf(e1, e2);
    }

    public static <E> HashObjSet<E> newImmutableSetOf(E e1, E e2, E e3) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3);
    }

    public static <E> HashObjSet<E> newImmutableSetOf(E e1, E e2, E e3, E e4) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4);
    }

    public static <E> HashObjSet<E> newImmutableSetOf(E e1, E e2, E e3, E e4,
            E e5, E... restElements) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    private HashObjSets() {}
}

