/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.Consumer;
import net.openhft.collect.set.ObjSetFactory;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashObjSet}s.
 *
 * @see HashObjSet
 * @see HashObjSets#getDefaultFactory()
 */
public interface HashObjSetFactory<E> extends ObjSetFactory<E>
        , ObjHashFactory<HashObjSetFactory<E>>
         {

    <E2> HashObjSetFactory<E2> withEquivalence(@Nullable Equivalence<E2> equivalence);

    

    

    

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet();

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set
     * and has the same equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elements, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4, Iterable<? extends E2> elems5, int expectedSize);

    

    
    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elements);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4, Iterable<? extends E2> elems5);


    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterator<? extends E2> elements);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(Iterator<? extends E2> elements,
            int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(
            net.openhft.function.Consumer<Consumer<E2>> elementsSupplier);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(
            net.openhft.function.Consumer<Consumer<E2>> elementsSupplier,
            int expectedSize);

    

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(E2[] elements);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSet(E2[] elements, int expectedSize);


    @Override
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2,
            E2 e3);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4);

    @Override
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4, E2 e5,
            E2... restElements);
    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet();

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set
     * and has the same equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elements, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4, Iterable<? extends E2> elems5, int expectedSize);

    

    
    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elements);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4, Iterable<? extends E2> elems5);


    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterator<? extends E2> elements);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(Iterator<? extends E2> elements,
            int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(
            net.openhft.function.Consumer<Consumer<E2>> elementsSupplier);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(
            net.openhft.function.Consumer<Consumer<E2>> elementsSupplier,
            int expectedSize);

    

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(E2[] elements);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSet(E2[] elements, int expectedSize);


    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1, E2 e2);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1, E2 e2,
            E2 e3);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4);

    @Override
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4, E2 e5,
            E2... restElements);

    

    /**
     * If the specified elements is a set
     * and has the same equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elements, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4, int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4, Iterable<? extends E2> elems5, int expectedSize);

    

    
    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elements);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1,
            Iterable<? extends E2> elems2, Iterable<? extends E2> elems3,
            Iterable<? extends E2> elems4, Iterable<? extends E2> elems5);


    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterator<? extends E2> elements);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(Iterator<? extends E2> elements,
            int expectedSize);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(
            net.openhft.function.Consumer<Consumer<E2>> elementsSupplier);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(
            net.openhft.function.Consumer<Consumer<E2>> elementsSupplier,
            int expectedSize);

    

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(E2[] elements);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSet(E2[] elements, int expectedSize);


    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2,
            E2 e3);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4);

    @Override
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4, E2 e5,
            E2... restElements);
}

