/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.function.LongConsumer;

import java.util.Iterator;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashLongSet}s, and
 * the default {@link HashLongSetFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashLongSet
 */
public final class HashLongSets {
    private static final ServiceLoader<HashLongSetFactory> LOADER =
            ServiceLoader.load(HashLongSetFactory.class);
    private static HashLongSetFactory defaultFactory = null;

    public static HashLongSetFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }
    
    

    public static  HashLongSet newMutableSet() {
        return getDefaultFactory().newMutableSet();
    }

    public static  HashLongSet newMutableSet(int expectedSize) {
        return getDefaultFactory().newMutableSet(expectedSize);
    }



    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashLongSet newMutableSet(
            Iterable<Long> elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, expectedSize);
    }

    public static  HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashLongSet newMutableSet(
            Iterable<Long> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2) {
        return getDefaultFactory().newMutableSet(elems1, elems2);
    }

    public static  HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3);
    }

    public static  HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashLongSet newMutableSet(Iterator<Long> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashLongSet newMutableSet(Iterator<Long> elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashLongSet newMutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier) {
        return getDefaultFactory().newMutableSet(elementsSupplier);
    }

    public static  HashLongSet newMutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elementsSupplier, expectedSize);
    }

    public static  HashLongSet newMutableSet(long[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashLongSet newMutableSet(long[] elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }
    
    public static HashLongSet newMutableSet(Long[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static HashLongSet newMutableSet(Long[] elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashLongSet newMutableSetOf(long e1) {
        return getDefaultFactory().newMutableSetOf(e1);
    }

    public static  HashLongSet newMutableSetOf(long e1, long e2) {
        return getDefaultFactory().newMutableSetOf(e1, e2);
    }

    public static  HashLongSet newMutableSetOf(long e1, long e2, long e3) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3);
    }

    public static  HashLongSet newMutableSetOf(long e1, long e2, long e3, long e4) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4);
    }

    public static  HashLongSet newMutableSetOf(long e1, long e2, long e3, long e4,
            long e5, long... restElements) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashLongSet newUpdatableSet(
            Iterable<Long> elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, expectedSize);
    }

    public static  HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashLongSet newUpdatableSet(
            Iterable<Long> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2);
    }

    public static  HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3);
    }

    public static  HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashLongSet newUpdatableSet(Iterator<Long> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashLongSet newUpdatableSet(Iterator<Long> elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashLongSet newUpdatableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier);
    }

    public static  HashLongSet newUpdatableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier, expectedSize);
    }

    public static  HashLongSet newUpdatableSet(long[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashLongSet newUpdatableSet(long[] elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }
    
    public static HashLongSet newUpdatableSet(Long[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static HashLongSet newUpdatableSet(Long[] elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashLongSet newUpdatableSetOf(long e1) {
        return getDefaultFactory().newUpdatableSetOf(e1);
    }

    public static  HashLongSet newUpdatableSetOf(long e1, long e2) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2);
    }

    public static  HashLongSet newUpdatableSetOf(long e1, long e2, long e3) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3);
    }

    public static  HashLongSet newUpdatableSetOf(long e1, long e2, long e3, long e4) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4);
    }

    public static  HashLongSet newUpdatableSetOf(long e1, long e2, long e3, long e4,
            long e5, long... restElements) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashLongSet newImmutableSet(
            Iterable<Long> elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, expectedSize);
    }

    public static  HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashLongSet newImmutableSet(
            Iterable<Long> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2) {
        return getDefaultFactory().newImmutableSet(elems1, elems2);
    }

    public static  HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3);
    }

    public static  HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashLongSet newImmutableSet(Iterator<Long> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashLongSet newImmutableSet(Iterator<Long> elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashLongSet newImmutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier) {
        return getDefaultFactory().newImmutableSet(elementsSupplier);
    }

    public static  HashLongSet newImmutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elementsSupplier, expectedSize);
    }

    public static  HashLongSet newImmutableSet(long[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashLongSet newImmutableSet(long[] elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }
    
    public static HashLongSet newImmutableSet(Long[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static HashLongSet newImmutableSet(Long[] elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashLongSet newImmutableSetOf(long e1) {
        return getDefaultFactory().newImmutableSetOf(e1);
    }

    public static  HashLongSet newImmutableSetOf(long e1, long e2) {
        return getDefaultFactory().newImmutableSetOf(e1, e2);
    }

    public static  HashLongSet newImmutableSetOf(long e1, long e2, long e3) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3);
    }

    public static  HashLongSet newImmutableSetOf(long e1, long e2, long e3, long e4) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4);
    }

    public static  HashLongSet newImmutableSetOf(long e1, long e2, long e3, long e4,
            long e5, long... restElements) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    private HashLongSets() {}
}

