/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.LongConsumer;
import net.openhft.collect.set.LongSetFactory;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashLongSet}s.
 *
 * @see HashLongSet
 * @see HashLongSets#getDefaultFactory()
 */
public interface HashLongSetFactory extends LongSetFactory
        , LongHashFactory<HashLongSetFactory>
         {


    

    

    

    @Override
     HashLongSet newMutableSet();

    @Override
     HashLongSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashLongSet newMutableSet(Iterable<Long> elements, int expectedSize);

    @Override
     HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, int expectedSize);

    @Override
     HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3, int expectedSize);

    @Override
     HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, int expectedSize);

    @Override
     HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5, int expectedSize);

    

    
    @Override
     HashLongSet newMutableSet(Iterable<Long> elements);

    @Override
     HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2);

    @Override
     HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3);

    @Override
     HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4);

    @Override
     HashLongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5);


    @Override
     HashLongSet newMutableSet(Iterator<Long> elements);

    @Override
     HashLongSet newMutableSet(Iterator<Long> elements,
            int expectedSize);

    @Override
     HashLongSet newMutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier);

    @Override
     HashLongSet newMutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashLongSet newMutableSet(long[] elements);

    @Override
     HashLongSet newMutableSet(long[] elements, int expectedSize);

    @Override
     HashLongSet newMutableSet(Long[] elements);

    @Override
     HashLongSet newMutableSet(Long[] elements, int expectedSize);

    @Override
     HashLongSet newMutableSetOf(long e1);

    @Override
     HashLongSet newMutableSetOf(long e1, long e2);

    @Override
     HashLongSet newMutableSetOf(long e1, long e2,
            long e3);

    @Override
     HashLongSet newMutableSetOf(long e1, long e2,
            long e3, long e4);

    @Override
     HashLongSet newMutableSetOf(long e1, long e2,
            long e3, long e4, long e5,
            long... restElements);
    @Override
     HashLongSet newUpdatableSet();

    @Override
     HashLongSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elements, int expectedSize);

    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, int expectedSize);

    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3, int expectedSize);

    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, int expectedSize);

    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5, int expectedSize);

    

    
    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elements);

    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2);

    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3);

    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4);

    @Override
     HashLongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5);


    @Override
     HashLongSet newUpdatableSet(Iterator<Long> elements);

    @Override
     HashLongSet newUpdatableSet(Iterator<Long> elements,
            int expectedSize);

    @Override
     HashLongSet newUpdatableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier);

    @Override
     HashLongSet newUpdatableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashLongSet newUpdatableSet(long[] elements);

    @Override
     HashLongSet newUpdatableSet(long[] elements, int expectedSize);

    @Override
     HashLongSet newUpdatableSet(Long[] elements);

    @Override
     HashLongSet newUpdatableSet(Long[] elements, int expectedSize);

    @Override
     HashLongSet newUpdatableSetOf(long e1);

    @Override
     HashLongSet newUpdatableSetOf(long e1, long e2);

    @Override
     HashLongSet newUpdatableSetOf(long e1, long e2,
            long e3);

    @Override
     HashLongSet newUpdatableSetOf(long e1, long e2,
            long e3, long e4);

    @Override
     HashLongSet newUpdatableSetOf(long e1, long e2,
            long e3, long e4, long e5,
            long... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashLongSet newImmutableSet(Iterable<Long> elements, int expectedSize);

    @Override
     HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, int expectedSize);

    @Override
     HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3, int expectedSize);

    @Override
     HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, int expectedSize);

    @Override
     HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5, int expectedSize);

    

    
    @Override
     HashLongSet newImmutableSet(Iterable<Long> elements);

    @Override
     HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2);

    @Override
     HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3);

    @Override
     HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4);

    @Override
     HashLongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5);


    @Override
     HashLongSet newImmutableSet(Iterator<Long> elements);

    @Override
     HashLongSet newImmutableSet(Iterator<Long> elements,
            int expectedSize);

    @Override
     HashLongSet newImmutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier);

    @Override
     HashLongSet newImmutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashLongSet newImmutableSet(long[] elements);

    @Override
     HashLongSet newImmutableSet(long[] elements, int expectedSize);

    @Override
     HashLongSet newImmutableSet(Long[] elements);

    @Override
     HashLongSet newImmutableSet(Long[] elements, int expectedSize);

    @Override
     HashLongSet newImmutableSetOf(long e1);

    @Override
     HashLongSet newImmutableSetOf(long e1, long e2);

    @Override
     HashLongSet newImmutableSetOf(long e1, long e2,
            long e3);

    @Override
     HashLongSet newImmutableSetOf(long e1, long e2,
            long e3, long e4);

    @Override
     HashLongSet newImmutableSetOf(long e1, long e2,
            long e3, long e4, long e5,
            long... restElements);
}

