/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.function.IntConsumer;

import java.util.Iterator;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashIntSet}s, and
 * the default {@link HashIntSetFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashIntSet
 */
public final class HashIntSets {
    private static final ServiceLoader<HashIntSetFactory> LOADER =
            ServiceLoader.load(HashIntSetFactory.class);
    private static HashIntSetFactory defaultFactory = null;

    public static HashIntSetFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }
    
    

    public static  HashIntSet newMutableSet() {
        return getDefaultFactory().newMutableSet();
    }

    public static  HashIntSet newMutableSet(int expectedSize) {
        return getDefaultFactory().newMutableSet(expectedSize);
    }



    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashIntSet newMutableSet(
            Iterable<Integer> elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, expectedSize);
    }

    public static  HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashIntSet newMutableSet(
            Iterable<Integer> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2) {
        return getDefaultFactory().newMutableSet(elems1, elems2);
    }

    public static  HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3);
    }

    public static  HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashIntSet newMutableSet(Iterator<Integer> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashIntSet newMutableSet(Iterator<Integer> elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashIntSet newMutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier) {
        return getDefaultFactory().newMutableSet(elementsSupplier);
    }

    public static  HashIntSet newMutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elementsSupplier, expectedSize);
    }

    public static  HashIntSet newMutableSet(int[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashIntSet newMutableSet(int[] elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }
    
    public static HashIntSet newMutableSet(Integer[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static HashIntSet newMutableSet(Integer[] elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashIntSet newMutableSetOf(int e1) {
        return getDefaultFactory().newMutableSetOf(e1);
    }

    public static  HashIntSet newMutableSetOf(int e1, int e2) {
        return getDefaultFactory().newMutableSetOf(e1, e2);
    }

    public static  HashIntSet newMutableSetOf(int e1, int e2, int e3) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3);
    }

    public static  HashIntSet newMutableSetOf(int e1, int e2, int e3, int e4) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4);
    }

    public static  HashIntSet newMutableSetOf(int e1, int e2, int e3, int e4,
            int e5, int... restElements) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashIntSet newUpdatableSet(
            Iterable<Integer> elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, expectedSize);
    }

    public static  HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashIntSet newUpdatableSet(
            Iterable<Integer> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2);
    }

    public static  HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3);
    }

    public static  HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashIntSet newUpdatableSet(Iterator<Integer> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashIntSet newUpdatableSet(Iterator<Integer> elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashIntSet newUpdatableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier);
    }

    public static  HashIntSet newUpdatableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier, expectedSize);
    }

    public static  HashIntSet newUpdatableSet(int[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashIntSet newUpdatableSet(int[] elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }
    
    public static HashIntSet newUpdatableSet(Integer[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static HashIntSet newUpdatableSet(Integer[] elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashIntSet newUpdatableSetOf(int e1) {
        return getDefaultFactory().newUpdatableSetOf(e1);
    }

    public static  HashIntSet newUpdatableSetOf(int e1, int e2) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2);
    }

    public static  HashIntSet newUpdatableSetOf(int e1, int e2, int e3) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3);
    }

    public static  HashIntSet newUpdatableSetOf(int e1, int e2, int e3, int e4) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4);
    }

    public static  HashIntSet newUpdatableSetOf(int e1, int e2, int e3, int e4,
            int e5, int... restElements) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashIntSet newImmutableSet(
            Iterable<Integer> elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, expectedSize);
    }

    public static  HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashIntSet newImmutableSet(
            Iterable<Integer> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2) {
        return getDefaultFactory().newImmutableSet(elems1, elems2);
    }

    public static  HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3);
    }

    public static  HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashIntSet newImmutableSet(Iterator<Integer> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashIntSet newImmutableSet(Iterator<Integer> elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashIntSet newImmutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier) {
        return getDefaultFactory().newImmutableSet(elementsSupplier);
    }

    public static  HashIntSet newImmutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elementsSupplier, expectedSize);
    }

    public static  HashIntSet newImmutableSet(int[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashIntSet newImmutableSet(int[] elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }
    
    public static HashIntSet newImmutableSet(Integer[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static HashIntSet newImmutableSet(Integer[] elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashIntSet newImmutableSetOf(int e1) {
        return getDefaultFactory().newImmutableSetOf(e1);
    }

    public static  HashIntSet newImmutableSetOf(int e1, int e2) {
        return getDefaultFactory().newImmutableSetOf(e1, e2);
    }

    public static  HashIntSet newImmutableSetOf(int e1, int e2, int e3) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3);
    }

    public static  HashIntSet newImmutableSetOf(int e1, int e2, int e3, int e4) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4);
    }

    public static  HashIntSet newImmutableSetOf(int e1, int e2, int e3, int e4,
            int e5, int... restElements) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    private HashIntSets() {}
}

