/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.IntConsumer;
import net.openhft.collect.set.IntSetFactory;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashIntSet}s.
 *
 * @see HashIntSet
 * @see HashIntSets#getDefaultFactory()
 */
public interface HashIntSetFactory extends IntSetFactory
        , IntHashFactory<HashIntSetFactory>
         {


    

    

    

    @Override
     HashIntSet newMutableSet();

    @Override
     HashIntSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashIntSet newMutableSet(Iterable<Integer> elements, int expectedSize);

    @Override
     HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, int expectedSize);

    @Override
     HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize);

    @Override
     HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, int expectedSize);

    @Override
     HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize);

    

    
    @Override
     HashIntSet newMutableSet(Iterable<Integer> elements);

    @Override
     HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2);

    @Override
     HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3);

    @Override
     HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4);

    @Override
     HashIntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5);


    @Override
     HashIntSet newMutableSet(Iterator<Integer> elements);

    @Override
     HashIntSet newMutableSet(Iterator<Integer> elements,
            int expectedSize);

    @Override
     HashIntSet newMutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier);

    @Override
     HashIntSet newMutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashIntSet newMutableSet(int[] elements);

    @Override
     HashIntSet newMutableSet(int[] elements, int expectedSize);

    @Override
     HashIntSet newMutableSet(Integer[] elements);

    @Override
     HashIntSet newMutableSet(Integer[] elements, int expectedSize);

    @Override
     HashIntSet newMutableSetOf(int e1);

    @Override
     HashIntSet newMutableSetOf(int e1, int e2);

    @Override
     HashIntSet newMutableSetOf(int e1, int e2,
            int e3);

    @Override
     HashIntSet newMutableSetOf(int e1, int e2,
            int e3, int e4);

    @Override
     HashIntSet newMutableSetOf(int e1, int e2,
            int e3, int e4, int e5,
            int... restElements);
    @Override
     HashIntSet newUpdatableSet();

    @Override
     HashIntSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elements, int expectedSize);

    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, int expectedSize);

    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize);

    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, int expectedSize);

    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize);

    

    
    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elements);

    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2);

    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3);

    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4);

    @Override
     HashIntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5);


    @Override
     HashIntSet newUpdatableSet(Iterator<Integer> elements);

    @Override
     HashIntSet newUpdatableSet(Iterator<Integer> elements,
            int expectedSize);

    @Override
     HashIntSet newUpdatableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier);

    @Override
     HashIntSet newUpdatableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashIntSet newUpdatableSet(int[] elements);

    @Override
     HashIntSet newUpdatableSet(int[] elements, int expectedSize);

    @Override
     HashIntSet newUpdatableSet(Integer[] elements);

    @Override
     HashIntSet newUpdatableSet(Integer[] elements, int expectedSize);

    @Override
     HashIntSet newUpdatableSetOf(int e1);

    @Override
     HashIntSet newUpdatableSetOf(int e1, int e2);

    @Override
     HashIntSet newUpdatableSetOf(int e1, int e2,
            int e3);

    @Override
     HashIntSet newUpdatableSetOf(int e1, int e2,
            int e3, int e4);

    @Override
     HashIntSet newUpdatableSetOf(int e1, int e2,
            int e3, int e4, int e5,
            int... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elements, int expectedSize);

    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, int expectedSize);

    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize);

    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, int expectedSize);

    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize);

    

    
    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elements);

    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2);

    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3);

    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4);

    @Override
     HashIntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5);


    @Override
     HashIntSet newImmutableSet(Iterator<Integer> elements);

    @Override
     HashIntSet newImmutableSet(Iterator<Integer> elements,
            int expectedSize);

    @Override
     HashIntSet newImmutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier);

    @Override
     HashIntSet newImmutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashIntSet newImmutableSet(int[] elements);

    @Override
     HashIntSet newImmutableSet(int[] elements, int expectedSize);

    @Override
     HashIntSet newImmutableSet(Integer[] elements);

    @Override
     HashIntSet newImmutableSet(Integer[] elements, int expectedSize);

    @Override
     HashIntSet newImmutableSetOf(int e1);

    @Override
     HashIntSet newImmutableSetOf(int e1, int e2);

    @Override
     HashIntSet newImmutableSetOf(int e1, int e2,
            int e3);

    @Override
     HashIntSet newImmutableSetOf(int e1, int e2,
            int e3, int e4);

    @Override
     HashIntSet newImmutableSetOf(int e1, int e2,
            int e3, int e4, int e5,
            int... restElements);
}

