/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.function.FloatConsumer;

import java.util.Iterator;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashFloatSet}s, and
 * the default {@link HashFloatSetFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashFloatSet
 */
public final class HashFloatSets {
    private static final ServiceLoader<HashFloatSetFactory> LOADER =
            ServiceLoader.load(HashFloatSetFactory.class);
    private static HashFloatSetFactory defaultFactory = null;

    public static HashFloatSetFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }
    
    

    public static  HashFloatSet newMutableSet() {
        return getDefaultFactory().newMutableSet();
    }

    public static  HashFloatSet newMutableSet(int expectedSize) {
        return getDefaultFactory().newMutableSet(expectedSize);
    }



    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashFloatSet newMutableSet(
            Iterable<Float> elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, expectedSize);
    }

    public static  HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashFloatSet newMutableSet(
            Iterable<Float> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2) {
        return getDefaultFactory().newMutableSet(elems1, elems2);
    }

    public static  HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3);
    }

    public static  HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashFloatSet newMutableSet(Iterator<Float> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashFloatSet newMutableSet(Iterator<Float> elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashFloatSet newMutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier) {
        return getDefaultFactory().newMutableSet(elementsSupplier);
    }

    public static  HashFloatSet newMutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elementsSupplier, expectedSize);
    }

    public static  HashFloatSet newMutableSet(float[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashFloatSet newMutableSet(float[] elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }
    
    public static HashFloatSet newMutableSet(Float[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static HashFloatSet newMutableSet(Float[] elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashFloatSet newMutableSetOf(float e1) {
        return getDefaultFactory().newMutableSetOf(e1);
    }

    public static  HashFloatSet newMutableSetOf(float e1, float e2) {
        return getDefaultFactory().newMutableSetOf(e1, e2);
    }

    public static  HashFloatSet newMutableSetOf(float e1, float e2, float e3) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3);
    }

    public static  HashFloatSet newMutableSetOf(float e1, float e2, float e3, float e4) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4);
    }

    public static  HashFloatSet newMutableSetOf(float e1, float e2, float e3, float e4,
            float e5, float... restElements) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashFloatSet newUpdatableSet(
            Iterable<Float> elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, expectedSize);
    }

    public static  HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashFloatSet newUpdatableSet(
            Iterable<Float> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2);
    }

    public static  HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3);
    }

    public static  HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashFloatSet newUpdatableSet(Iterator<Float> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashFloatSet newUpdatableSet(Iterator<Float> elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashFloatSet newUpdatableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier);
    }

    public static  HashFloatSet newUpdatableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier, expectedSize);
    }

    public static  HashFloatSet newUpdatableSet(float[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashFloatSet newUpdatableSet(float[] elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }
    
    public static HashFloatSet newUpdatableSet(Float[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static HashFloatSet newUpdatableSet(Float[] elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashFloatSet newUpdatableSetOf(float e1) {
        return getDefaultFactory().newUpdatableSetOf(e1);
    }

    public static  HashFloatSet newUpdatableSetOf(float e1, float e2) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2);
    }

    public static  HashFloatSet newUpdatableSetOf(float e1, float e2, float e3) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3);
    }

    public static  HashFloatSet newUpdatableSetOf(float e1, float e2, float e3, float e4) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4);
    }

    public static  HashFloatSet newUpdatableSetOf(float e1, float e2, float e3, float e4,
            float e5, float... restElements) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashFloatSet newImmutableSet(
            Iterable<Float> elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, expectedSize);
    }

    public static  HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashFloatSet newImmutableSet(
            Iterable<Float> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2) {
        return getDefaultFactory().newImmutableSet(elems1, elems2);
    }

    public static  HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3);
    }

    public static  HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashFloatSet newImmutableSet(Iterator<Float> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashFloatSet newImmutableSet(Iterator<Float> elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashFloatSet newImmutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier) {
        return getDefaultFactory().newImmutableSet(elementsSupplier);
    }

    public static  HashFloatSet newImmutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elementsSupplier, expectedSize);
    }

    public static  HashFloatSet newImmutableSet(float[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashFloatSet newImmutableSet(float[] elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }
    
    public static HashFloatSet newImmutableSet(Float[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static HashFloatSet newImmutableSet(Float[] elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashFloatSet newImmutableSetOf(float e1) {
        return getDefaultFactory().newImmutableSetOf(e1);
    }

    public static  HashFloatSet newImmutableSetOf(float e1, float e2) {
        return getDefaultFactory().newImmutableSetOf(e1, e2);
    }

    public static  HashFloatSet newImmutableSetOf(float e1, float e2, float e3) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3);
    }

    public static  HashFloatSet newImmutableSetOf(float e1, float e2, float e3, float e4) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4);
    }

    public static  HashFloatSet newImmutableSetOf(float e1, float e2, float e3, float e4,
            float e5, float... restElements) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    private HashFloatSets() {}
}

