/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.FloatConsumer;
import net.openhft.collect.set.FloatSetFactory;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashFloatSet}s.
 *
 * @see HashFloatSet
 * @see HashFloatSets#getDefaultFactory()
 */
public interface HashFloatSetFactory extends FloatSetFactory
        , HashContainerFactory<HashFloatSetFactory> {


    

    

    

    @Override
     HashFloatSet newMutableSet();

    @Override
     HashFloatSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashFloatSet newMutableSet(Iterable<Float> elements, int expectedSize);

    @Override
     HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, int expectedSize);

    @Override
     HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize);

    @Override
     HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, int expectedSize);

    @Override
     HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize);

    

    
    @Override
     HashFloatSet newMutableSet(Iterable<Float> elements);

    @Override
     HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2);

    @Override
     HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3);

    @Override
     HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4);

    @Override
     HashFloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5);


    @Override
     HashFloatSet newMutableSet(Iterator<Float> elements);

    @Override
     HashFloatSet newMutableSet(Iterator<Float> elements,
            int expectedSize);

    @Override
     HashFloatSet newMutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier);

    @Override
     HashFloatSet newMutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashFloatSet newMutableSet(float[] elements);

    @Override
     HashFloatSet newMutableSet(float[] elements, int expectedSize);

    @Override
     HashFloatSet newMutableSet(Float[] elements);

    @Override
     HashFloatSet newMutableSet(Float[] elements, int expectedSize);

    @Override
     HashFloatSet newMutableSetOf(float e1);

    @Override
     HashFloatSet newMutableSetOf(float e1, float e2);

    @Override
     HashFloatSet newMutableSetOf(float e1, float e2,
            float e3);

    @Override
     HashFloatSet newMutableSetOf(float e1, float e2,
            float e3, float e4);

    @Override
     HashFloatSet newMutableSetOf(float e1, float e2,
            float e3, float e4, float e5,
            float... restElements);
    @Override
     HashFloatSet newUpdatableSet();

    @Override
     HashFloatSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elements, int expectedSize);

    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, int expectedSize);

    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize);

    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, int expectedSize);

    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize);

    

    
    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elements);

    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2);

    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3);

    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4);

    @Override
     HashFloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5);


    @Override
     HashFloatSet newUpdatableSet(Iterator<Float> elements);

    @Override
     HashFloatSet newUpdatableSet(Iterator<Float> elements,
            int expectedSize);

    @Override
     HashFloatSet newUpdatableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier);

    @Override
     HashFloatSet newUpdatableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashFloatSet newUpdatableSet(float[] elements);

    @Override
     HashFloatSet newUpdatableSet(float[] elements, int expectedSize);

    @Override
     HashFloatSet newUpdatableSet(Float[] elements);

    @Override
     HashFloatSet newUpdatableSet(Float[] elements, int expectedSize);

    @Override
     HashFloatSet newUpdatableSetOf(float e1);

    @Override
     HashFloatSet newUpdatableSetOf(float e1, float e2);

    @Override
     HashFloatSet newUpdatableSetOf(float e1, float e2,
            float e3);

    @Override
     HashFloatSet newUpdatableSetOf(float e1, float e2,
            float e3, float e4);

    @Override
     HashFloatSet newUpdatableSetOf(float e1, float e2,
            float e3, float e4, float e5,
            float... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elements, int expectedSize);

    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, int expectedSize);

    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize);

    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, int expectedSize);

    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize);

    

    
    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elements);

    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2);

    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3);

    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4);

    @Override
     HashFloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5);


    @Override
     HashFloatSet newImmutableSet(Iterator<Float> elements);

    @Override
     HashFloatSet newImmutableSet(Iterator<Float> elements,
            int expectedSize);

    @Override
     HashFloatSet newImmutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier);

    @Override
     HashFloatSet newImmutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashFloatSet newImmutableSet(float[] elements);

    @Override
     HashFloatSet newImmutableSet(float[] elements, int expectedSize);

    @Override
     HashFloatSet newImmutableSet(Float[] elements);

    @Override
     HashFloatSet newImmutableSet(Float[] elements, int expectedSize);

    @Override
     HashFloatSet newImmutableSetOf(float e1);

    @Override
     HashFloatSet newImmutableSetOf(float e1, float e2);

    @Override
     HashFloatSet newImmutableSetOf(float e1, float e2,
            float e3);

    @Override
     HashFloatSet newImmutableSetOf(float e1, float e2,
            float e3, float e4);

    @Override
     HashFloatSet newImmutableSetOf(float e1, float e2,
            float e3, float e4, float e5,
            float... restElements);
}

