/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.function.DoubleConsumer;

import java.util.Iterator;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashDoubleSet}s, and
 * the default {@link HashDoubleSetFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashDoubleSet
 */
public final class HashDoubleSets {
    private static final ServiceLoader<HashDoubleSetFactory> LOADER =
            ServiceLoader.load(HashDoubleSetFactory.class);
    private static HashDoubleSetFactory defaultFactory = null;

    public static HashDoubleSetFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }
    
    

    public static  HashDoubleSet newMutableSet() {
        return getDefaultFactory().newMutableSet();
    }

    public static  HashDoubleSet newMutableSet(int expectedSize) {
        return getDefaultFactory().newMutableSet(expectedSize);
    }



    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashDoubleSet newMutableSet(
            Iterable<Double> elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, expectedSize);
    }

    public static  HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashDoubleSet newMutableSet(
            Iterable<Double> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2) {
        return getDefaultFactory().newMutableSet(elems1, elems2);
    }

    public static  HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3);
    }

    public static  HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashDoubleSet newMutableSet(Iterator<Double> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashDoubleSet newMutableSet(Iterator<Double> elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashDoubleSet newMutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier) {
        return getDefaultFactory().newMutableSet(elementsSupplier);
    }

    public static  HashDoubleSet newMutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elementsSupplier, expectedSize);
    }

    public static  HashDoubleSet newMutableSet(double[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashDoubleSet newMutableSet(double[] elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }
    
    public static HashDoubleSet newMutableSet(Double[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static HashDoubleSet newMutableSet(Double[] elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashDoubleSet newMutableSetOf(double e1) {
        return getDefaultFactory().newMutableSetOf(e1);
    }

    public static  HashDoubleSet newMutableSetOf(double e1, double e2) {
        return getDefaultFactory().newMutableSetOf(e1, e2);
    }

    public static  HashDoubleSet newMutableSetOf(double e1, double e2, double e3) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3);
    }

    public static  HashDoubleSet newMutableSetOf(double e1, double e2, double e3, double e4) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4);
    }

    public static  HashDoubleSet newMutableSetOf(double e1, double e2, double e3, double e4,
            double e5, double... restElements) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashDoubleSet newUpdatableSet(
            Iterable<Double> elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, expectedSize);
    }

    public static  HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashDoubleSet newUpdatableSet(
            Iterable<Double> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2);
    }

    public static  HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3);
    }

    public static  HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashDoubleSet newUpdatableSet(Iterator<Double> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashDoubleSet newUpdatableSet(Iterator<Double> elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashDoubleSet newUpdatableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier);
    }

    public static  HashDoubleSet newUpdatableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier, expectedSize);
    }

    public static  HashDoubleSet newUpdatableSet(double[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashDoubleSet newUpdatableSet(double[] elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }
    
    public static HashDoubleSet newUpdatableSet(Double[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static HashDoubleSet newUpdatableSet(Double[] elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashDoubleSet newUpdatableSetOf(double e1) {
        return getDefaultFactory().newUpdatableSetOf(e1);
    }

    public static  HashDoubleSet newUpdatableSetOf(double e1, double e2) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2);
    }

    public static  HashDoubleSet newUpdatableSetOf(double e1, double e2, double e3) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3);
    }

    public static  HashDoubleSet newUpdatableSetOf(double e1, double e2, double e3, double e4) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4);
    }

    public static  HashDoubleSet newUpdatableSetOf(double e1, double e2, double e3, double e4,
            double e5, double... restElements) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashDoubleSet newImmutableSet(
            Iterable<Double> elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, expectedSize);
    }

    public static  HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashDoubleSet newImmutableSet(
            Iterable<Double> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2) {
        return getDefaultFactory().newImmutableSet(elems1, elems2);
    }

    public static  HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3);
    }

    public static  HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashDoubleSet newImmutableSet(Iterator<Double> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashDoubleSet newImmutableSet(Iterator<Double> elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashDoubleSet newImmutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier) {
        return getDefaultFactory().newImmutableSet(elementsSupplier);
    }

    public static  HashDoubleSet newImmutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elementsSupplier, expectedSize);
    }

    public static  HashDoubleSet newImmutableSet(double[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashDoubleSet newImmutableSet(double[] elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }
    
    public static HashDoubleSet newImmutableSet(Double[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static HashDoubleSet newImmutableSet(Double[] elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashDoubleSet newImmutableSetOf(double e1) {
        return getDefaultFactory().newImmutableSetOf(e1);
    }

    public static  HashDoubleSet newImmutableSetOf(double e1, double e2) {
        return getDefaultFactory().newImmutableSetOf(e1, e2);
    }

    public static  HashDoubleSet newImmutableSetOf(double e1, double e2, double e3) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3);
    }

    public static  HashDoubleSet newImmutableSetOf(double e1, double e2, double e3, double e4) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4);
    }

    public static  HashDoubleSet newImmutableSetOf(double e1, double e2, double e3, double e4,
            double e5, double... restElements) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    private HashDoubleSets() {}
}

