/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.DoubleConsumer;
import net.openhft.collect.set.DoubleSetFactory;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashDoubleSet}s.
 *
 * @see HashDoubleSet
 * @see HashDoubleSets#getDefaultFactory()
 */
public interface HashDoubleSetFactory extends DoubleSetFactory
        , HashContainerFactory<HashDoubleSetFactory> {


    

    

    

    @Override
     HashDoubleSet newMutableSet();

    @Override
     HashDoubleSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elements, int expectedSize);

    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, int expectedSize);

    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize);

    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, int expectedSize);

    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize);

    

    
    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elements);

    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2);

    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3);

    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4);

    @Override
     HashDoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5);


    @Override
     HashDoubleSet newMutableSet(Iterator<Double> elements);

    @Override
     HashDoubleSet newMutableSet(Iterator<Double> elements,
            int expectedSize);

    @Override
     HashDoubleSet newMutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier);

    @Override
     HashDoubleSet newMutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashDoubleSet newMutableSet(double[] elements);

    @Override
     HashDoubleSet newMutableSet(double[] elements, int expectedSize);

    @Override
     HashDoubleSet newMutableSet(Double[] elements);

    @Override
     HashDoubleSet newMutableSet(Double[] elements, int expectedSize);

    @Override
     HashDoubleSet newMutableSetOf(double e1);

    @Override
     HashDoubleSet newMutableSetOf(double e1, double e2);

    @Override
     HashDoubleSet newMutableSetOf(double e1, double e2,
            double e3);

    @Override
     HashDoubleSet newMutableSetOf(double e1, double e2,
            double e3, double e4);

    @Override
     HashDoubleSet newMutableSetOf(double e1, double e2,
            double e3, double e4, double e5,
            double... restElements);
    @Override
     HashDoubleSet newUpdatableSet();

    @Override
     HashDoubleSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elements, int expectedSize);

    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, int expectedSize);

    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize);

    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, int expectedSize);

    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize);

    

    
    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elements);

    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2);

    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3);

    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4);

    @Override
     HashDoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5);


    @Override
     HashDoubleSet newUpdatableSet(Iterator<Double> elements);

    @Override
     HashDoubleSet newUpdatableSet(Iterator<Double> elements,
            int expectedSize);

    @Override
     HashDoubleSet newUpdatableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier);

    @Override
     HashDoubleSet newUpdatableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashDoubleSet newUpdatableSet(double[] elements);

    @Override
     HashDoubleSet newUpdatableSet(double[] elements, int expectedSize);

    @Override
     HashDoubleSet newUpdatableSet(Double[] elements);

    @Override
     HashDoubleSet newUpdatableSet(Double[] elements, int expectedSize);

    @Override
     HashDoubleSet newUpdatableSetOf(double e1);

    @Override
     HashDoubleSet newUpdatableSetOf(double e1, double e2);

    @Override
     HashDoubleSet newUpdatableSetOf(double e1, double e2,
            double e3);

    @Override
     HashDoubleSet newUpdatableSetOf(double e1, double e2,
            double e3, double e4);

    @Override
     HashDoubleSet newUpdatableSetOf(double e1, double e2,
            double e3, double e4, double e5,
            double... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elements, int expectedSize);

    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, int expectedSize);

    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize);

    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, int expectedSize);

    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize);

    

    
    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elements);

    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2);

    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3);

    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4);

    @Override
     HashDoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5);


    @Override
     HashDoubleSet newImmutableSet(Iterator<Double> elements);

    @Override
     HashDoubleSet newImmutableSet(Iterator<Double> elements,
            int expectedSize);

    @Override
     HashDoubleSet newImmutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier);

    @Override
     HashDoubleSet newImmutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashDoubleSet newImmutableSet(double[] elements);

    @Override
     HashDoubleSet newImmutableSet(double[] elements, int expectedSize);

    @Override
     HashDoubleSet newImmutableSet(Double[] elements);

    @Override
     HashDoubleSet newImmutableSet(Double[] elements, int expectedSize);

    @Override
     HashDoubleSet newImmutableSetOf(double e1);

    @Override
     HashDoubleSet newImmutableSetOf(double e1, double e2);

    @Override
     HashDoubleSet newImmutableSetOf(double e1, double e2,
            double e3);

    @Override
     HashDoubleSet newImmutableSetOf(double e1, double e2,
            double e3, double e4);

    @Override
     HashDoubleSet newImmutableSetOf(double e1, double e2,
            double e3, double e4, double e5,
            double... restElements);
}

