/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.function.ByteConsumer;

import java.util.Iterator;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashByteSet}s, and
 * the default {@link HashByteSetFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashByteSet
 */
public final class HashByteSets {
    private static final ServiceLoader<HashByteSetFactory> LOADER =
            ServiceLoader.load(HashByteSetFactory.class);
    private static HashByteSetFactory defaultFactory = null;

    public static HashByteSetFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }
    
    

    public static  HashByteSet newMutableSet() {
        return getDefaultFactory().newMutableSet();
    }

    public static  HashByteSet newMutableSet(int expectedSize) {
        return getDefaultFactory().newMutableSet(expectedSize);
    }



    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashByteSet newMutableSet(
            Iterable<Byte> elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, expectedSize);
    }

    public static  HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashByteSet newMutableSet(
            Iterable<Byte> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2) {
        return getDefaultFactory().newMutableSet(elems1, elems2);
    }

    public static  HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3);
    }

    public static  HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5) {
        return getDefaultFactory().newMutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashByteSet newMutableSet(Iterator<Byte> elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashByteSet newMutableSet(Iterator<Byte> elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashByteSet newMutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier) {
        return getDefaultFactory().newMutableSet(elementsSupplier);
    }

    public static  HashByteSet newMutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elementsSupplier, expectedSize);
    }

    public static  HashByteSet newMutableSet(byte[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static  HashByteSet newMutableSet(byte[] elements,
            int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }
    
    public static HashByteSet newMutableSet(Byte[] elements) {
        return getDefaultFactory().newMutableSet(elements);
    }

    public static HashByteSet newMutableSet(Byte[] elements, int expectedSize) {
        return getDefaultFactory().newMutableSet(elements, expectedSize);
    }

    public static  HashByteSet newMutableSetOf(byte e1) {
        return getDefaultFactory().newMutableSetOf(e1);
    }

    public static  HashByteSet newMutableSetOf(byte e1, byte e2) {
        return getDefaultFactory().newMutableSetOf(e1, e2);
    }

    public static  HashByteSet newMutableSetOf(byte e1, byte e2, byte e3) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3);
    }

    public static  HashByteSet newMutableSetOf(byte e1, byte e2, byte e3, byte e4) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4);
    }

    public static  HashByteSet newMutableSetOf(byte e1, byte e2, byte e3, byte e4,
            byte e5, byte... restElements) {
        return getDefaultFactory().newMutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashByteSet newUpdatableSet(
            Iterable<Byte> elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, expectedSize);
    }

    public static  HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashByteSet newUpdatableSet(
            Iterable<Byte> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2);
    }

    public static  HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3);
    }

    public static  HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5) {
        return getDefaultFactory().newUpdatableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashByteSet newUpdatableSet(Iterator<Byte> elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashByteSet newUpdatableSet(Iterator<Byte> elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashByteSet newUpdatableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier);
    }

    public static  HashByteSet newUpdatableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elementsSupplier, expectedSize);
    }

    public static  HashByteSet newUpdatableSet(byte[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static  HashByteSet newUpdatableSet(byte[] elements,
            int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }
    
    public static HashByteSet newUpdatableSet(Byte[] elements) {
        return getDefaultFactory().newUpdatableSet(elements);
    }

    public static HashByteSet newUpdatableSet(Byte[] elements, int expectedSize) {
        return getDefaultFactory().newUpdatableSet(elements, expectedSize);
    }

    public static  HashByteSet newUpdatableSetOf(byte e1) {
        return getDefaultFactory().newUpdatableSetOf(e1);
    }

    public static  HashByteSet newUpdatableSetOf(byte e1, byte e2) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2);
    }

    public static  HashByteSet newUpdatableSetOf(byte e1, byte e2, byte e3) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3);
    }

    public static  HashByteSet newUpdatableSetOf(byte e1, byte e2, byte e3, byte e4) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4);
    }

    public static  HashByteSet newUpdatableSetOf(byte e1, byte e2, byte e3, byte e4,
            byte e5, byte... restElements) {
        return getDefaultFactory().newUpdatableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    
    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    public static  HashByteSet newImmutableSet(
            Iterable<Byte> elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, expectedSize);
    }

    public static  HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, expectedSize);
    }

    public static  HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, expectedSize);
    }

    public static  HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5, expectedSize);
    }

    
    

    
    public static  HashByteSet newImmutableSet(
            Iterable<Byte> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2) {
        return getDefaultFactory().newImmutableSet(elems1, elems2);
    }

    public static  HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3);
    }

    public static  HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4);
    }

    public static  HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5) {
        return getDefaultFactory().newImmutableSet(elems1, elems2, elems3, elems4, elems5);
    }


    public static  HashByteSet newImmutableSet(Iterator<Byte> elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashByteSet newImmutableSet(Iterator<Byte> elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashByteSet newImmutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier) {
        return getDefaultFactory().newImmutableSet(elementsSupplier);
    }

    public static  HashByteSet newImmutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elementsSupplier, expectedSize);
    }

    public static  HashByteSet newImmutableSet(byte[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static  HashByteSet newImmutableSet(byte[] elements,
            int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }
    
    public static HashByteSet newImmutableSet(Byte[] elements) {
        return getDefaultFactory().newImmutableSet(elements);
    }

    public static HashByteSet newImmutableSet(Byte[] elements, int expectedSize) {
        return getDefaultFactory().newImmutableSet(elements, expectedSize);
    }

    public static  HashByteSet newImmutableSetOf(byte e1) {
        return getDefaultFactory().newImmutableSetOf(e1);
    }

    public static  HashByteSet newImmutableSetOf(byte e1, byte e2) {
        return getDefaultFactory().newImmutableSetOf(e1, e2);
    }

    public static  HashByteSet newImmutableSetOf(byte e1, byte e2, byte e3) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3);
    }

    public static  HashByteSet newImmutableSetOf(byte e1, byte e2, byte e3, byte e4) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4);
    }

    public static  HashByteSet newImmutableSetOf(byte e1, byte e2, byte e3, byte e4,
            byte e5, byte... restElements) {
        return getDefaultFactory().newImmutableSetOf(e1, e2, e3, e4, e5, restElements);
    }

    private HashByteSets() {}
}

