/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ByteConsumer;
import net.openhft.collect.set.ByteSetFactory;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashByteSet}s.
 *
 * @see HashByteSet
 * @see HashByteSets#getDefaultFactory()
 */
public interface HashByteSetFactory extends ByteSetFactory
        , ByteHashFactory<HashByteSetFactory>
         {


    

    

    

    @Override
     HashByteSet newMutableSet();

    @Override
     HashByteSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashByteSet newMutableSet(Iterable<Byte> elements, int expectedSize);

    @Override
     HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, int expectedSize);

    @Override
     HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize);

    @Override
     HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, int expectedSize);

    @Override
     HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize);

    

    
    @Override
     HashByteSet newMutableSet(Iterable<Byte> elements);

    @Override
     HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2);

    @Override
     HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3);

    @Override
     HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4);

    @Override
     HashByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5);


    @Override
     HashByteSet newMutableSet(Iterator<Byte> elements);

    @Override
     HashByteSet newMutableSet(Iterator<Byte> elements,
            int expectedSize);

    @Override
     HashByteSet newMutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier);

    @Override
     HashByteSet newMutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashByteSet newMutableSet(byte[] elements);

    @Override
     HashByteSet newMutableSet(byte[] elements, int expectedSize);

    @Override
     HashByteSet newMutableSet(Byte[] elements);

    @Override
     HashByteSet newMutableSet(Byte[] elements, int expectedSize);

    @Override
     HashByteSet newMutableSetOf(byte e1);

    @Override
     HashByteSet newMutableSetOf(byte e1, byte e2);

    @Override
     HashByteSet newMutableSetOf(byte e1, byte e2,
            byte e3);

    @Override
     HashByteSet newMutableSetOf(byte e1, byte e2,
            byte e3, byte e4);

    @Override
     HashByteSet newMutableSetOf(byte e1, byte e2,
            byte e3, byte e4, byte e5,
            byte... restElements);
    @Override
     HashByteSet newUpdatableSet();

    @Override
     HashByteSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elements, int expectedSize);

    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, int expectedSize);

    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize);

    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, int expectedSize);

    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize);

    

    
    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elements);

    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2);

    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3);

    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4);

    @Override
     HashByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5);


    @Override
     HashByteSet newUpdatableSet(Iterator<Byte> elements);

    @Override
     HashByteSet newUpdatableSet(Iterator<Byte> elements,
            int expectedSize);

    @Override
     HashByteSet newUpdatableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier);

    @Override
     HashByteSet newUpdatableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashByteSet newUpdatableSet(byte[] elements);

    @Override
     HashByteSet newUpdatableSet(byte[] elements, int expectedSize);

    @Override
     HashByteSet newUpdatableSet(Byte[] elements);

    @Override
     HashByteSet newUpdatableSet(Byte[] elements, int expectedSize);

    @Override
     HashByteSet newUpdatableSetOf(byte e1);

    @Override
     HashByteSet newUpdatableSetOf(byte e1, byte e2);

    @Override
     HashByteSet newUpdatableSetOf(byte e1, byte e2,
            byte e3);

    @Override
     HashByteSet newUpdatableSetOf(byte e1, byte e2,
            byte e3, byte e4);

    @Override
     HashByteSet newUpdatableSetOf(byte e1, byte e2,
            byte e3, byte e4, byte e5,
            byte... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elements, int expectedSize);

    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, int expectedSize);

    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize);

    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, int expectedSize);

    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize);

    

    
    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elements);

    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2);

    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3);

    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4);

    @Override
     HashByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5);


    @Override
     HashByteSet newImmutableSet(Iterator<Byte> elements);

    @Override
     HashByteSet newImmutableSet(Iterator<Byte> elements,
            int expectedSize);

    @Override
     HashByteSet newImmutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier);

    @Override
     HashByteSet newImmutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier,
            int expectedSize);

    

    @Override
     HashByteSet newImmutableSet(byte[] elements);

    @Override
     HashByteSet newImmutableSet(byte[] elements, int expectedSize);

    @Override
     HashByteSet newImmutableSet(Byte[] elements);

    @Override
     HashByteSet newImmutableSet(Byte[] elements, int expectedSize);

    @Override
     HashByteSet newImmutableSetOf(byte e1);

    @Override
     HashByteSet newImmutableSetOf(byte e1, byte e2);

    @Override
     HashByteSet newImmutableSetOf(byte e1, byte e2,
            byte e3);

    @Override
     HashByteSet newImmutableSetOf(byte e1, byte e2,
            byte e3, byte e4);

    @Override
     HashByteSet newImmutableSetOf(byte e1, byte e2,
            byte e3, byte e4, byte e5,
            byte... restElements);
}

