/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set;

import net.openhft.collect.Equivalence;
import net.openhft.function.ShortConsumer;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code ShortSet}s.
 *
 * @see ShortSet
 */
public interface ShortSetFactory {


    

    

    

     ShortSet newMutableSet();

     ShortSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     ShortSet newMutableSet(Iterable<Short> elements, int expectedSize);

     ShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, int expectedSize);

     ShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize);

     ShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, int expectedSize);

     ShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize);

    

    
     ShortSet newMutableSet(Iterable<Short> elements);

     ShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2);

     ShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3);

     ShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4);

     ShortSet newMutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5);


     ShortSet newMutableSet(Iterator<Short> elements);

     ShortSet newMutableSet(Iterator<Short> elements, int expectedSize);

     ShortSet newMutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier);

     ShortSet newMutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier,
            int expectedSize);

    

     ShortSet newMutableSet(short[] elements);

     ShortSet newMutableSet(short[] elements, int expectedSize);

     ShortSet newMutableSet(Short[] elements);

     ShortSet newMutableSet(Short[] elements, int expectedSize);

     ShortSet newMutableSetOf(short e1);

     ShortSet newMutableSetOf(short e1, short e2);

     ShortSet newMutableSetOf(short e1, short e2, short e3);

     ShortSet newMutableSetOf(short e1, short e2, short e3,
            short e4);

     ShortSet newMutableSetOf(short e1, short e2, short e3,
            short e4, short e5, short... restElements);
     ShortSet newUpdatableSet();

     ShortSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     ShortSet newUpdatableSet(Iterable<Short> elements, int expectedSize);

     ShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, int expectedSize);

     ShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize);

     ShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, int expectedSize);

     ShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize);

    

    
     ShortSet newUpdatableSet(Iterable<Short> elements);

     ShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2);

     ShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3);

     ShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4);

     ShortSet newUpdatableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5);


     ShortSet newUpdatableSet(Iterator<Short> elements);

     ShortSet newUpdatableSet(Iterator<Short> elements, int expectedSize);

     ShortSet newUpdatableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier);

     ShortSet newUpdatableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier,
            int expectedSize);

    

     ShortSet newUpdatableSet(short[] elements);

     ShortSet newUpdatableSet(short[] elements, int expectedSize);

     ShortSet newUpdatableSet(Short[] elements);

     ShortSet newUpdatableSet(Short[] elements, int expectedSize);

     ShortSet newUpdatableSetOf(short e1);

     ShortSet newUpdatableSetOf(short e1, short e2);

     ShortSet newUpdatableSetOf(short e1, short e2, short e3);

     ShortSet newUpdatableSetOf(short e1, short e2, short e3,
            short e4);

     ShortSet newUpdatableSetOf(short e1, short e2, short e3,
            short e4, short e5, short... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     ShortSet newImmutableSet(Iterable<Short> elements, int expectedSize);

     ShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, int expectedSize);

     ShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize);

     ShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, int expectedSize);

     ShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize);

    

    
     ShortSet newImmutableSet(Iterable<Short> elements);

     ShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2);

     ShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3);

     ShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4);

     ShortSet newImmutableSet(Iterable<Short> elems1,
            Iterable<Short> elems2, Iterable<Short> elems3,
            Iterable<Short> elems4, Iterable<Short> elems5);


     ShortSet newImmutableSet(Iterator<Short> elements);

     ShortSet newImmutableSet(Iterator<Short> elements, int expectedSize);

     ShortSet newImmutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier);

     ShortSet newImmutableSet(
            net.openhft.function.Consumer<ShortConsumer> elementsSupplier,
            int expectedSize);

    

     ShortSet newImmutableSet(short[] elements);

     ShortSet newImmutableSet(short[] elements, int expectedSize);

     ShortSet newImmutableSet(Short[] elements);

     ShortSet newImmutableSet(Short[] elements, int expectedSize);

     ShortSet newImmutableSetOf(short e1);

     ShortSet newImmutableSetOf(short e1, short e2);

     ShortSet newImmutableSetOf(short e1, short e2, short e3);

     ShortSet newImmutableSetOf(short e1, short e2, short e3,
            short e4);

     ShortSet newImmutableSetOf(short e1, short e2, short e3,
            short e4, short e5, short... restElements);
}

