/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set;

import net.openhft.collect.Equivalence;
import net.openhft.function.LongConsumer;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code LongSet}s.
 *
 * @see LongSet
 */
public interface LongSetFactory {


    

    

    

     LongSet newMutableSet();

     LongSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     LongSet newMutableSet(Iterable<Long> elements, int expectedSize);

     LongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, int expectedSize);

     LongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3, int expectedSize);

     LongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, int expectedSize);

     LongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5, int expectedSize);

    

    
     LongSet newMutableSet(Iterable<Long> elements);

     LongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2);

     LongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3);

     LongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4);

     LongSet newMutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5);


     LongSet newMutableSet(Iterator<Long> elements);

     LongSet newMutableSet(Iterator<Long> elements, int expectedSize);

     LongSet newMutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier);

     LongSet newMutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier,
            int expectedSize);

    

     LongSet newMutableSet(long[] elements);

     LongSet newMutableSet(long[] elements, int expectedSize);

     LongSet newMutableSet(Long[] elements);

     LongSet newMutableSet(Long[] elements, int expectedSize);

     LongSet newMutableSetOf(long e1);

     LongSet newMutableSetOf(long e1, long e2);

     LongSet newMutableSetOf(long e1, long e2, long e3);

     LongSet newMutableSetOf(long e1, long e2, long e3,
            long e4);

     LongSet newMutableSetOf(long e1, long e2, long e3,
            long e4, long e5, long... restElements);
     LongSet newUpdatableSet();

     LongSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     LongSet newUpdatableSet(Iterable<Long> elements, int expectedSize);

     LongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, int expectedSize);

     LongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3, int expectedSize);

     LongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, int expectedSize);

     LongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5, int expectedSize);

    

    
     LongSet newUpdatableSet(Iterable<Long> elements);

     LongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2);

     LongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3);

     LongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4);

     LongSet newUpdatableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5);


     LongSet newUpdatableSet(Iterator<Long> elements);

     LongSet newUpdatableSet(Iterator<Long> elements, int expectedSize);

     LongSet newUpdatableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier);

     LongSet newUpdatableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier,
            int expectedSize);

    

     LongSet newUpdatableSet(long[] elements);

     LongSet newUpdatableSet(long[] elements, int expectedSize);

     LongSet newUpdatableSet(Long[] elements);

     LongSet newUpdatableSet(Long[] elements, int expectedSize);

     LongSet newUpdatableSetOf(long e1);

     LongSet newUpdatableSetOf(long e1, long e2);

     LongSet newUpdatableSetOf(long e1, long e2, long e3);

     LongSet newUpdatableSetOf(long e1, long e2, long e3,
            long e4);

     LongSet newUpdatableSetOf(long e1, long e2, long e3,
            long e4, long e5, long... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     LongSet newImmutableSet(Iterable<Long> elements, int expectedSize);

     LongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, int expectedSize);

     LongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3, int expectedSize);

     LongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, int expectedSize);

     LongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5, int expectedSize);

    

    
     LongSet newImmutableSet(Iterable<Long> elements);

     LongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2);

     LongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3);

     LongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4);

     LongSet newImmutableSet(Iterable<Long> elems1,
            Iterable<Long> elems2, Iterable<Long> elems3,
            Iterable<Long> elems4, Iterable<Long> elems5);


     LongSet newImmutableSet(Iterator<Long> elements);

     LongSet newImmutableSet(Iterator<Long> elements, int expectedSize);

     LongSet newImmutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier);

     LongSet newImmutableSet(
            net.openhft.function.Consumer<LongConsumer> elementsSupplier,
            int expectedSize);

    

     LongSet newImmutableSet(long[] elements);

     LongSet newImmutableSet(long[] elements, int expectedSize);

     LongSet newImmutableSet(Long[] elements);

     LongSet newImmutableSet(Long[] elements, int expectedSize);

     LongSet newImmutableSetOf(long e1);

     LongSet newImmutableSetOf(long e1, long e2);

     LongSet newImmutableSetOf(long e1, long e2, long e3);

     LongSet newImmutableSetOf(long e1, long e2, long e3,
            long e4);

     LongSet newImmutableSetOf(long e1, long e2, long e3,
            long e4, long e5, long... restElements);
}

