/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set;

import net.openhft.collect.Equivalence;
import net.openhft.function.IntConsumer;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code IntSet}s.
 *
 * @see IntSet
 */
public interface IntSetFactory {


    

    

    

     IntSet newMutableSet();

     IntSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     IntSet newMutableSet(Iterable<Integer> elements, int expectedSize);

     IntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, int expectedSize);

     IntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize);

     IntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, int expectedSize);

     IntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize);

    

    
     IntSet newMutableSet(Iterable<Integer> elements);

     IntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2);

     IntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3);

     IntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4);

     IntSet newMutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5);


     IntSet newMutableSet(Iterator<Integer> elements);

     IntSet newMutableSet(Iterator<Integer> elements, int expectedSize);

     IntSet newMutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier);

     IntSet newMutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier,
            int expectedSize);

    

     IntSet newMutableSet(int[] elements);

     IntSet newMutableSet(int[] elements, int expectedSize);

     IntSet newMutableSet(Integer[] elements);

     IntSet newMutableSet(Integer[] elements, int expectedSize);

     IntSet newMutableSetOf(int e1);

     IntSet newMutableSetOf(int e1, int e2);

     IntSet newMutableSetOf(int e1, int e2, int e3);

     IntSet newMutableSetOf(int e1, int e2, int e3,
            int e4);

     IntSet newMutableSetOf(int e1, int e2, int e3,
            int e4, int e5, int... restElements);
     IntSet newUpdatableSet();

     IntSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     IntSet newUpdatableSet(Iterable<Integer> elements, int expectedSize);

     IntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, int expectedSize);

     IntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize);

     IntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, int expectedSize);

     IntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize);

    

    
     IntSet newUpdatableSet(Iterable<Integer> elements);

     IntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2);

     IntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3);

     IntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4);

     IntSet newUpdatableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5);


     IntSet newUpdatableSet(Iterator<Integer> elements);

     IntSet newUpdatableSet(Iterator<Integer> elements, int expectedSize);

     IntSet newUpdatableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier);

     IntSet newUpdatableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier,
            int expectedSize);

    

     IntSet newUpdatableSet(int[] elements);

     IntSet newUpdatableSet(int[] elements, int expectedSize);

     IntSet newUpdatableSet(Integer[] elements);

     IntSet newUpdatableSet(Integer[] elements, int expectedSize);

     IntSet newUpdatableSetOf(int e1);

     IntSet newUpdatableSetOf(int e1, int e2);

     IntSet newUpdatableSetOf(int e1, int e2, int e3);

     IntSet newUpdatableSetOf(int e1, int e2, int e3,
            int e4);

     IntSet newUpdatableSetOf(int e1, int e2, int e3,
            int e4, int e5, int... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     IntSet newImmutableSet(Iterable<Integer> elements, int expectedSize);

     IntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, int expectedSize);

     IntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize);

     IntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, int expectedSize);

     IntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize);

    

    
     IntSet newImmutableSet(Iterable<Integer> elements);

     IntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2);

     IntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3);

     IntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4);

     IntSet newImmutableSet(Iterable<Integer> elems1,
            Iterable<Integer> elems2, Iterable<Integer> elems3,
            Iterable<Integer> elems4, Iterable<Integer> elems5);


     IntSet newImmutableSet(Iterator<Integer> elements);

     IntSet newImmutableSet(Iterator<Integer> elements, int expectedSize);

     IntSet newImmutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier);

     IntSet newImmutableSet(
            net.openhft.function.Consumer<IntConsumer> elementsSupplier,
            int expectedSize);

    

     IntSet newImmutableSet(int[] elements);

     IntSet newImmutableSet(int[] elements, int expectedSize);

     IntSet newImmutableSet(Integer[] elements);

     IntSet newImmutableSet(Integer[] elements, int expectedSize);

     IntSet newImmutableSetOf(int e1);

     IntSet newImmutableSetOf(int e1, int e2);

     IntSet newImmutableSetOf(int e1, int e2, int e3);

     IntSet newImmutableSetOf(int e1, int e2, int e3,
            int e4);

     IntSet newImmutableSetOf(int e1, int e2, int e3,
            int e4, int e5, int... restElements);
}

