/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set;

import net.openhft.collect.Equivalence;
import net.openhft.function.FloatConsumer;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code FloatSet}s.
 *
 * @see FloatSet
 */
public interface FloatSetFactory {


    

    

    

     FloatSet newMutableSet();

     FloatSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     FloatSet newMutableSet(Iterable<Float> elements, int expectedSize);

     FloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, int expectedSize);

     FloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize);

     FloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, int expectedSize);

     FloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize);

    

    
     FloatSet newMutableSet(Iterable<Float> elements);

     FloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2);

     FloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3);

     FloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4);

     FloatSet newMutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5);


     FloatSet newMutableSet(Iterator<Float> elements);

     FloatSet newMutableSet(Iterator<Float> elements, int expectedSize);

     FloatSet newMutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier);

     FloatSet newMutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier,
            int expectedSize);

    

     FloatSet newMutableSet(float[] elements);

     FloatSet newMutableSet(float[] elements, int expectedSize);

     FloatSet newMutableSet(Float[] elements);

     FloatSet newMutableSet(Float[] elements, int expectedSize);

     FloatSet newMutableSetOf(float e1);

     FloatSet newMutableSetOf(float e1, float e2);

     FloatSet newMutableSetOf(float e1, float e2, float e3);

     FloatSet newMutableSetOf(float e1, float e2, float e3,
            float e4);

     FloatSet newMutableSetOf(float e1, float e2, float e3,
            float e4, float e5, float... restElements);
     FloatSet newUpdatableSet();

     FloatSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     FloatSet newUpdatableSet(Iterable<Float> elements, int expectedSize);

     FloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, int expectedSize);

     FloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize);

     FloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, int expectedSize);

     FloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize);

    

    
     FloatSet newUpdatableSet(Iterable<Float> elements);

     FloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2);

     FloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3);

     FloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4);

     FloatSet newUpdatableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5);


     FloatSet newUpdatableSet(Iterator<Float> elements);

     FloatSet newUpdatableSet(Iterator<Float> elements, int expectedSize);

     FloatSet newUpdatableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier);

     FloatSet newUpdatableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier,
            int expectedSize);

    

     FloatSet newUpdatableSet(float[] elements);

     FloatSet newUpdatableSet(float[] elements, int expectedSize);

     FloatSet newUpdatableSet(Float[] elements);

     FloatSet newUpdatableSet(Float[] elements, int expectedSize);

     FloatSet newUpdatableSetOf(float e1);

     FloatSet newUpdatableSetOf(float e1, float e2);

     FloatSet newUpdatableSetOf(float e1, float e2, float e3);

     FloatSet newUpdatableSetOf(float e1, float e2, float e3,
            float e4);

     FloatSet newUpdatableSetOf(float e1, float e2, float e3,
            float e4, float e5, float... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     FloatSet newImmutableSet(Iterable<Float> elements, int expectedSize);

     FloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, int expectedSize);

     FloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize);

     FloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, int expectedSize);

     FloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize);

    

    
     FloatSet newImmutableSet(Iterable<Float> elements);

     FloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2);

     FloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3);

     FloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4);

     FloatSet newImmutableSet(Iterable<Float> elems1,
            Iterable<Float> elems2, Iterable<Float> elems3,
            Iterable<Float> elems4, Iterable<Float> elems5);


     FloatSet newImmutableSet(Iterator<Float> elements);

     FloatSet newImmutableSet(Iterator<Float> elements, int expectedSize);

     FloatSet newImmutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier);

     FloatSet newImmutableSet(
            net.openhft.function.Consumer<FloatConsumer> elementsSupplier,
            int expectedSize);

    

     FloatSet newImmutableSet(float[] elements);

     FloatSet newImmutableSet(float[] elements, int expectedSize);

     FloatSet newImmutableSet(Float[] elements);

     FloatSet newImmutableSet(Float[] elements, int expectedSize);

     FloatSet newImmutableSetOf(float e1);

     FloatSet newImmutableSetOf(float e1, float e2);

     FloatSet newImmutableSetOf(float e1, float e2, float e3);

     FloatSet newImmutableSetOf(float e1, float e2, float e3,
            float e4);

     FloatSet newImmutableSetOf(float e1, float e2, float e3,
            float e4, float e5, float... restElements);
}

