/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set;

import net.openhft.collect.Equivalence;
import net.openhft.function.DoubleConsumer;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code DoubleSet}s.
 *
 * @see DoubleSet
 */
public interface DoubleSetFactory {


    

    

    

     DoubleSet newMutableSet();

     DoubleSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     DoubleSet newMutableSet(Iterable<Double> elements, int expectedSize);

     DoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, int expectedSize);

     DoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize);

     DoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, int expectedSize);

     DoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize);

    

    
     DoubleSet newMutableSet(Iterable<Double> elements);

     DoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2);

     DoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3);

     DoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4);

     DoubleSet newMutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5);


     DoubleSet newMutableSet(Iterator<Double> elements);

     DoubleSet newMutableSet(Iterator<Double> elements, int expectedSize);

     DoubleSet newMutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier);

     DoubleSet newMutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier,
            int expectedSize);

    

     DoubleSet newMutableSet(double[] elements);

     DoubleSet newMutableSet(double[] elements, int expectedSize);

     DoubleSet newMutableSet(Double[] elements);

     DoubleSet newMutableSet(Double[] elements, int expectedSize);

     DoubleSet newMutableSetOf(double e1);

     DoubleSet newMutableSetOf(double e1, double e2);

     DoubleSet newMutableSetOf(double e1, double e2, double e3);

     DoubleSet newMutableSetOf(double e1, double e2, double e3,
            double e4);

     DoubleSet newMutableSetOf(double e1, double e2, double e3,
            double e4, double e5, double... restElements);
     DoubleSet newUpdatableSet();

     DoubleSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     DoubleSet newUpdatableSet(Iterable<Double> elements, int expectedSize);

     DoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, int expectedSize);

     DoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize);

     DoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, int expectedSize);

     DoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize);

    

    
     DoubleSet newUpdatableSet(Iterable<Double> elements);

     DoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2);

     DoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3);

     DoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4);

     DoubleSet newUpdatableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5);


     DoubleSet newUpdatableSet(Iterator<Double> elements);

     DoubleSet newUpdatableSet(Iterator<Double> elements, int expectedSize);

     DoubleSet newUpdatableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier);

     DoubleSet newUpdatableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier,
            int expectedSize);

    

     DoubleSet newUpdatableSet(double[] elements);

     DoubleSet newUpdatableSet(double[] elements, int expectedSize);

     DoubleSet newUpdatableSet(Double[] elements);

     DoubleSet newUpdatableSet(Double[] elements, int expectedSize);

     DoubleSet newUpdatableSetOf(double e1);

     DoubleSet newUpdatableSetOf(double e1, double e2);

     DoubleSet newUpdatableSetOf(double e1, double e2, double e3);

     DoubleSet newUpdatableSetOf(double e1, double e2, double e3,
            double e4);

     DoubleSet newUpdatableSetOf(double e1, double e2, double e3,
            double e4, double e5, double... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     DoubleSet newImmutableSet(Iterable<Double> elements, int expectedSize);

     DoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, int expectedSize);

     DoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize);

     DoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, int expectedSize);

     DoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize);

    

    
     DoubleSet newImmutableSet(Iterable<Double> elements);

     DoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2);

     DoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3);

     DoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4);

     DoubleSet newImmutableSet(Iterable<Double> elems1,
            Iterable<Double> elems2, Iterable<Double> elems3,
            Iterable<Double> elems4, Iterable<Double> elems5);


     DoubleSet newImmutableSet(Iterator<Double> elements);

     DoubleSet newImmutableSet(Iterator<Double> elements, int expectedSize);

     DoubleSet newImmutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier);

     DoubleSet newImmutableSet(
            net.openhft.function.Consumer<DoubleConsumer> elementsSupplier,
            int expectedSize);

    

     DoubleSet newImmutableSet(double[] elements);

     DoubleSet newImmutableSet(double[] elements, int expectedSize);

     DoubleSet newImmutableSet(Double[] elements);

     DoubleSet newImmutableSet(Double[] elements, int expectedSize);

     DoubleSet newImmutableSetOf(double e1);

     DoubleSet newImmutableSetOf(double e1, double e2);

     DoubleSet newImmutableSetOf(double e1, double e2, double e3);

     DoubleSet newImmutableSetOf(double e1, double e2, double e3,
            double e4);

     DoubleSet newImmutableSetOf(double e1, double e2, double e3,
            double e4, double e5, double... restElements);
}

