/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.set;

import net.openhft.collect.Equivalence;
import net.openhft.function.ByteConsumer;
import javax.annotation.Nullable;

import java.util.Iterator;


/**
 * An immutable factory of {@code ByteSet}s.
 *
 * @see ByteSet
 */
public interface ByteSetFactory {


    

    

    

     ByteSet newMutableSet();

     ByteSet newMutableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     ByteSet newMutableSet(Iterable<Byte> elements, int expectedSize);

     ByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, int expectedSize);

     ByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize);

     ByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, int expectedSize);

     ByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize);

    

    
     ByteSet newMutableSet(Iterable<Byte> elements);

     ByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2);

     ByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3);

     ByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4);

     ByteSet newMutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5);


     ByteSet newMutableSet(Iterator<Byte> elements);

     ByteSet newMutableSet(Iterator<Byte> elements, int expectedSize);

     ByteSet newMutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier);

     ByteSet newMutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier,
            int expectedSize);

    

     ByteSet newMutableSet(byte[] elements);

     ByteSet newMutableSet(byte[] elements, int expectedSize);

     ByteSet newMutableSet(Byte[] elements);

     ByteSet newMutableSet(Byte[] elements, int expectedSize);

     ByteSet newMutableSetOf(byte e1);

     ByteSet newMutableSetOf(byte e1, byte e2);

     ByteSet newMutableSetOf(byte e1, byte e2, byte e3);

     ByteSet newMutableSetOf(byte e1, byte e2, byte e3,
            byte e4);

     ByteSet newMutableSetOf(byte e1, byte e2, byte e3,
            byte e4, byte e5, byte... restElements);
     ByteSet newUpdatableSet();

     ByteSet newUpdatableSet(int expectedSize);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     ByteSet newUpdatableSet(Iterable<Byte> elements, int expectedSize);

     ByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, int expectedSize);

     ByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize);

     ByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, int expectedSize);

     ByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize);

    

    
     ByteSet newUpdatableSet(Iterable<Byte> elements);

     ByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2);

     ByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3);

     ByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4);

     ByteSet newUpdatableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5);


     ByteSet newUpdatableSet(Iterator<Byte> elements);

     ByteSet newUpdatableSet(Iterator<Byte> elements, int expectedSize);

     ByteSet newUpdatableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier);

     ByteSet newUpdatableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier,
            int expectedSize);

    

     ByteSet newUpdatableSet(byte[] elements);

     ByteSet newUpdatableSet(byte[] elements, int expectedSize);

     ByteSet newUpdatableSet(Byte[] elements);

     ByteSet newUpdatableSet(Byte[] elements, int expectedSize);

     ByteSet newUpdatableSetOf(byte e1);

     ByteSet newUpdatableSetOf(byte e1, byte e2);

     ByteSet newUpdatableSetOf(byte e1, byte e2, byte e3);

     ByteSet newUpdatableSetOf(byte e1, byte e2, byte e3,
            byte e4);

     ByteSet newUpdatableSetOf(byte e1, byte e2, byte e3,
            byte e4, byte e5, byte... restElements);

    

    /**
     * If the specified elements is a set,
     * {@code expectedSize} is ignored.
     */
     ByteSet newImmutableSet(Iterable<Byte> elements, int expectedSize);

     ByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, int expectedSize);

     ByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize);

     ByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, int expectedSize);

     ByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize);

    

    
     ByteSet newImmutableSet(Iterable<Byte> elements);

     ByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2);

     ByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3);

     ByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4);

     ByteSet newImmutableSet(Iterable<Byte> elems1,
            Iterable<Byte> elems2, Iterable<Byte> elems3,
            Iterable<Byte> elems4, Iterable<Byte> elems5);


     ByteSet newImmutableSet(Iterator<Byte> elements);

     ByteSet newImmutableSet(Iterator<Byte> elements, int expectedSize);

     ByteSet newImmutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier);

     ByteSet newImmutableSet(
            net.openhft.function.Consumer<ByteConsumer> elementsSupplier,
            int expectedSize);

    

     ByteSet newImmutableSet(byte[] elements);

     ByteSet newImmutableSet(byte[] elements, int expectedSize);

     ByteSet newImmutableSet(Byte[] elements);

     ByteSet newImmutableSet(Byte[] elements, int expectedSize);

     ByteSet newImmutableSetOf(byte e1);

     ByteSet newImmutableSetOf(byte e1, byte e2);

     ByteSet newImmutableSetOf(byte e1, byte e2, byte e3);

     ByteSet newImmutableSetOf(byte e1, byte e2, byte e3,
            byte e4);

     ByteSet newImmutableSetOf(byte e1, byte e2, byte e3,
            byte e4, byte e5, byte... restElements);
}

