/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ShortShortConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashShortShortMap}s, and
 * the default {@link HashShortShortMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashShortShortMap
 */
public final class HashShortShortMaps {

    

    private static final ServiceLoader<HashShortShortMapFactory> LOADER =
            ServiceLoader.load(HashShortShortMapFactory.class);
    private static HashShortShortMapFactory defaultFactory = null;

    public static HashShortShortMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashShortShortMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashShortShortMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortShortMap newMutableMap(
            Map<Short, Short> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortShortMap newMutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashShortShortMap newMutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortShortMap newMutableMap(
            short[] keys, short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortShortMap newMutableMap(
            short[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortShortMap newMutableMap(
            Short[] keys, Short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortShortMap newMutableMap(
            Short[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortShortMap newMutableMap(Iterable<Short> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortShortMap newMutableMap(Iterable<Short> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashShortShortMap newMutableMapOf(
            short k1, short v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashShortShortMap newMutableMapOf(
            short k1, short v1, short k2, short v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortShortMap newMutableMapOf(
            short k1, short v1, short k2, short v2,
            short k3, short v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortShortMap newMutableMapOf(
            short k1, short v1, short k2, short v2,
            short k3, short v3, short k4, short v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortShortMap newMutableMapOf(
            short k1, short v1, short k2, short v2,
            short k3, short v3, short k4, short v4,
            short k5, short v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortShortMap newUpdatableMap(
            Map<Short, Short> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortShortMap newUpdatableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashShortShortMap newUpdatableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortShortMap newUpdatableMap(
            short[] keys, short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortShortMap newUpdatableMap(
            short[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortShortMap newUpdatableMap(
            Short[] keys, Short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortShortMap newUpdatableMap(
            Short[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortShortMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortShortMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashShortShortMap newUpdatableMapOf(
            short k1, short v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashShortShortMap newUpdatableMapOf(
            short k1, short v1, short k2, short v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortShortMap newUpdatableMapOf(
            short k1, short v1, short k2, short v2,
            short k3, short v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortShortMap newUpdatableMapOf(
            short k1, short v1, short k2, short v2,
            short k3, short v3, short k4, short v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortShortMap newUpdatableMapOf(
            short k1, short v1, short k2, short v2,
            short k3, short v3, short k4, short v4,
            short k5, short v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortShortMap newImmutableMap(
            Map<Short, Short> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortShortMap newImmutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashShortShortMap newImmutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortShortMap newImmutableMap(
            short[] keys, short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortShortMap newImmutableMap(
            short[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortShortMap newImmutableMap(
            Short[] keys, Short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortShortMap newImmutableMap(
            Short[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortShortMap newImmutableMap(Iterable<Short> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortShortMap newImmutableMap(Iterable<Short> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashShortShortMap newImmutableMapOf(
            short k1, short v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashShortShortMap newImmutableMapOf(
            short k1, short v1, short k2, short v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortShortMap newImmutableMapOf(
            short k1, short v1, short k2, short v2,
            short k3, short v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortShortMap newImmutableMapOf(
            short k1, short v1, short k2, short v2,
            short k3, short v3, short k4, short v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortShortMap newImmutableMapOf(
            short k1, short v1, short k2, short v2,
            short k3, short v3, short k4, short v4,
            short k5, short v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashShortShortMaps() {}
}

