/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ShortShortConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashShortShortMaps}
 *
 * @see HashShortShortMap
 * @see HashShortShortMaps#getDefaultFactory()
 */
public interface HashShortShortMapFactory extends ShortShortMapFactory
        , ShortHashFactory<HashShortShortMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashShortShortMapFactory withDefaultValue(short defaultValue);

    @Override
     HashShortShortMap newMutableMap();

    @Override
     HashShortShortMap newMutableMap(int expectedSize);

    


    @Override
     HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, int expectedSize);

    @Override
     HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3, int expectedSize);

    @Override
     HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, int expectedSize);

    @Override
     HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5, int expectedSize);

    

    
    @Override
     HashShortShortMap newMutableMap(Map<Short, Short> map);

    @Override
     HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2);

    @Override
     HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3);

    @Override
     HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4);

    @Override
     HashShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5);


    @Override
     HashShortShortMap newMutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier);

    @Override
     HashShortShortMap newMutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortShortMap newMutableMap(short[] keys, short[] values);

    @Override
     HashShortShortMap newMutableMap(short[] keys, short[] values,
            int expectedSize);

    @Override
     HashShortShortMap newMutableMap(
            Short[] keys, Short[] values);

    @Override
     HashShortShortMap newMutableMap(
            Short[] keys, Short[] values, int expectedSize);

    @Override
     HashShortShortMap newMutableMap(Iterable<Short> keys,
            Iterable<Short> values);

    @Override
     HashShortShortMap newMutableMap(Iterable<Short> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashShortShortMap newMutableMapOf(short k1, short v1);

    @Override
     HashShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2);

    @Override
     HashShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3);

    @Override
     HashShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4);

    @Override
     HashShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4, short k5, short v5);
    @Override
     HashShortShortMap newUpdatableMap();

    @Override
     HashShortShortMap newUpdatableMap(int expectedSize);

    


    @Override
     HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, int expectedSize);

    @Override
     HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3, int expectedSize);

    @Override
     HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, int expectedSize);

    @Override
     HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5, int expectedSize);

    

    
    @Override
     HashShortShortMap newUpdatableMap(Map<Short, Short> map);

    @Override
     HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2);

    @Override
     HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3);

    @Override
     HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4);

    @Override
     HashShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5);


    @Override
     HashShortShortMap newUpdatableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier);

    @Override
     HashShortShortMap newUpdatableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortShortMap newUpdatableMap(short[] keys, short[] values);

    @Override
     HashShortShortMap newUpdatableMap(short[] keys, short[] values,
            int expectedSize);

    @Override
     HashShortShortMap newUpdatableMap(
            Short[] keys, Short[] values);

    @Override
     HashShortShortMap newUpdatableMap(
            Short[] keys, Short[] values, int expectedSize);

    @Override
     HashShortShortMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Short> values);

    @Override
     HashShortShortMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashShortShortMap newUpdatableMapOf(short k1, short v1);

    @Override
     HashShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2);

    @Override
     HashShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3);

    @Override
     HashShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4);

    @Override
     HashShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4, short k5, short v5);

    


    @Override
     HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, int expectedSize);

    @Override
     HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3, int expectedSize);

    @Override
     HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, int expectedSize);

    @Override
     HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5, int expectedSize);

    

    
    @Override
     HashShortShortMap newImmutableMap(Map<Short, Short> map);

    @Override
     HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2);

    @Override
     HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3);

    @Override
     HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4);

    @Override
     HashShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5);


    @Override
     HashShortShortMap newImmutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier);

    @Override
     HashShortShortMap newImmutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortShortMap newImmutableMap(short[] keys, short[] values);

    @Override
     HashShortShortMap newImmutableMap(short[] keys, short[] values,
            int expectedSize);

    @Override
     HashShortShortMap newImmutableMap(
            Short[] keys, Short[] values);

    @Override
     HashShortShortMap newImmutableMap(
            Short[] keys, Short[] values, int expectedSize);

    @Override
     HashShortShortMap newImmutableMap(Iterable<Short> keys,
            Iterable<Short> values);

    @Override
     HashShortShortMap newImmutableMap(Iterable<Short> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashShortShortMap newImmutableMapOf(short k1, short v1);

    @Override
     HashShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2);

    @Override
     HashShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3);

    @Override
     HashShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4);

    @Override
     HashShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4, short k5, short v5);
}

