/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ShortObjConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashShortObjMap}s, and
 * the default {@link HashShortObjMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashShortObjMap
 */
public final class HashShortObjMaps {

    

    private static final ServiceLoader<HashShortObjMapFactory> LOADER =
            ServiceLoader.load(HashShortObjMapFactory.class);
    private static HashShortObjMapFactory<Object> defaultFactory = null;

    public static HashShortObjMapFactory<Object> getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static <V> HashShortObjMap<V> newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static <V> HashShortObjMap<V> newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static <V> HashShortObjMap<V> newMutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static <V> HashShortObjMap<V> newMutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashShortObjMap<V> newMutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashShortObjMap<V> newMutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4, Map<Short, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashShortObjMap<V> newMutableMap(
            Map<Short, ? extends V> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static <V> HashShortObjMap<V> newMutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static <V> HashShortObjMap<V> newMutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static <V> HashShortObjMap<V> newMutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static <V> HashShortObjMap<V> newMutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4, Map<Short, ? extends V> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashShortObjMap<V> newMutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static <V> HashShortObjMap<V> newMutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashShortObjMap<V> newMutableMap(
            short[] keys, V[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashShortObjMap<V> newMutableMap(
            short[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <V> HashShortObjMap<V> newMutableMap(
            Short[] keys, V[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashShortObjMap<V> newMutableMap(
            Short[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <V> HashShortObjMap<V> newMutableMap(Iterable<Short> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashShortObjMap<V> newMutableMap(Iterable<Short> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static <V> HashShortObjMap<V> newMutableMapOf(
            short k1, V v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static <V> HashShortObjMap<V> newMutableMapOf(
            short k1, V v1, short k2, V v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashShortObjMap<V> newMutableMapOf(
            short k1, V v1, short k2, V v2,
            short k3, V v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashShortObjMap<V> newMutableMapOf(
            short k1, V v1, short k2, V v2,
            short k3, V v3, short k4, V v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashShortObjMap<V> newMutableMapOf(
            short k1, V v1, short k2, V v2,
            short k3, V v3, short k4, V v4,
            short k5, V v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static <V> HashShortObjMap<V> newUpdatableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4, Map<Short, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashShortObjMap<V> newUpdatableMap(
            Map<Short, ? extends V> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4, Map<Short, ? extends V> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashShortObjMap<V> newUpdatableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(
            short[] keys, V[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(
            short[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(
            Short[] keys, V[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(
            Short[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(Iterable<Short> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashShortObjMap<V> newUpdatableMap(Iterable<Short> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static <V> HashShortObjMap<V> newUpdatableMapOf(
            short k1, V v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static <V> HashShortObjMap<V> newUpdatableMapOf(
            short k1, V v1, short k2, V v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashShortObjMap<V> newUpdatableMapOf(
            short k1, V v1, short k2, V v2,
            short k3, V v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashShortObjMap<V> newUpdatableMapOf(
            short k1, V v1, short k2, V v2,
            short k3, V v3, short k4, V v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashShortObjMap<V> newUpdatableMapOf(
            short k1, V v1, short k2, V v2,
            short k3, V v3, short k4, V v4,
            short k5, V v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static <V> HashShortObjMap<V> newImmutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4, Map<Short, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashShortObjMap<V> newImmutableMap(
            Map<Short, ? extends V> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(Map<Short, ? extends V> map1,
            Map<Short, ? extends V> map2, Map<Short, ? extends V> map3,
            Map<Short, ? extends V> map4, Map<Short, ? extends V> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashShortObjMap<V> newImmutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(
            short[] keys, V[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(
            short[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(
            Short[] keys, V[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(
            Short[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(Iterable<Short> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashShortObjMap<V> newImmutableMap(Iterable<Short> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static <V> HashShortObjMap<V> newImmutableMapOf(
            short k1, V v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static <V> HashShortObjMap<V> newImmutableMapOf(
            short k1, V v1, short k2, V v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashShortObjMap<V> newImmutableMapOf(
            short k1, V v1, short k2, V v2,
            short k3, V v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashShortObjMap<V> newImmutableMapOf(
            short k1, V v1, short k2, V v2,
            short k3, V v3, short k4, V v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashShortObjMap<V> newImmutableMapOf(
            short k1, V v1, short k2, V v2,
            short k3, V v3, short k4, V v4,
            short k5, V v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashShortObjMaps() {}
}

