/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ShortObjConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashShortObjMaps}
 *
 * @see HashShortObjMap
 * @see HashShortObjMaps#getDefaultFactory()
 */
public interface HashShortObjMapFactory<V> extends ShortObjMapFactory<V>
        , ShortHashFactory<HashShortObjMapFactory<V>>
         {

    

    

    

    

    

    
    

    
    


    @Override
    <VE> HashShortObjMapFactory<VE>
    withValueEquivalence(@Nullable Equivalence<VE> valueEquivalence);


    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap();

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(int expectedSize);

    


    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5);


    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(short[] keys, V2[] values);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(short[] keys, V2[] values,
            int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(
            Short[] keys, V2[] values);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(
            Short[] keys, V2[] values, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Iterable<Short> keys,
            Iterable<? extends V2> values);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMap(Iterable<Short> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4);

    @Override
    <V2 extends V> HashShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4, short k5, V2 v5);
    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap();

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(int expectedSize);

    


    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5);


    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(short[] keys, V2[] values);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(short[] keys, V2[] values,
            int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(
            Short[] keys, V2[] values);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(
            Short[] keys, V2[] values, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Iterable<Short> keys,
            Iterable<? extends V2> values);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMap(Iterable<Short> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4);

    @Override
    <V2 extends V> HashShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4, short k5, V2 v5);

    


    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5);


    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(short[] keys, V2[] values);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(short[] keys, V2[] values,
            int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(
            Short[] keys, V2[] values);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(
            Short[] keys, V2[] values, int expectedSize);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Iterable<Short> keys,
            Iterable<? extends V2> values);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMap(Iterable<Short> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4);

    @Override
    <V2 extends V> HashShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4, short k5, V2 v5);
}

