/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ShortLongConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashShortLongMap}s, and
 * the default {@link HashShortLongMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashShortLongMap
 */
public final class HashShortLongMaps {

    

    private static final ServiceLoader<HashShortLongMapFactory> LOADER =
            ServiceLoader.load(HashShortLongMapFactory.class);
    private static HashShortLongMapFactory defaultFactory = null;

    public static HashShortLongMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashShortLongMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashShortLongMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortLongMap newMutableMap(
            Map<Short, Long> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortLongMap newMutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashShortLongMap newMutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortLongMap newMutableMap(
            short[] keys, long[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortLongMap newMutableMap(
            short[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortLongMap newMutableMap(
            Short[] keys, Long[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortLongMap newMutableMap(
            Short[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortLongMap newMutableMap(Iterable<Short> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortLongMap newMutableMap(Iterable<Short> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashShortLongMap newMutableMapOf(
            short k1, long v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashShortLongMap newMutableMapOf(
            short k1, long v1, short k2, long v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortLongMap newMutableMapOf(
            short k1, long v1, short k2, long v2,
            short k3, long v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortLongMap newMutableMapOf(
            short k1, long v1, short k2, long v2,
            short k3, long v3, short k4, long v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortLongMap newMutableMapOf(
            short k1, long v1, short k2, long v2,
            short k3, long v3, short k4, long v4,
            short k5, long v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortLongMap newUpdatableMap(
            Map<Short, Long> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortLongMap newUpdatableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashShortLongMap newUpdatableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortLongMap newUpdatableMap(
            short[] keys, long[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortLongMap newUpdatableMap(
            short[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortLongMap newUpdatableMap(
            Short[] keys, Long[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortLongMap newUpdatableMap(
            Short[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortLongMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortLongMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashShortLongMap newUpdatableMapOf(
            short k1, long v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashShortLongMap newUpdatableMapOf(
            short k1, long v1, short k2, long v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortLongMap newUpdatableMapOf(
            short k1, long v1, short k2, long v2,
            short k3, long v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortLongMap newUpdatableMapOf(
            short k1, long v1, short k2, long v2,
            short k3, long v3, short k4, long v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortLongMap newUpdatableMapOf(
            short k1, long v1, short k2, long v2,
            short k3, long v3, short k4, long v4,
            short k5, long v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortLongMap newImmutableMap(
            Map<Short, Long> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortLongMap newImmutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashShortLongMap newImmutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortLongMap newImmutableMap(
            short[] keys, long[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortLongMap newImmutableMap(
            short[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortLongMap newImmutableMap(
            Short[] keys, Long[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortLongMap newImmutableMap(
            Short[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortLongMap newImmutableMap(Iterable<Short> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortLongMap newImmutableMap(Iterable<Short> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashShortLongMap newImmutableMapOf(
            short k1, long v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashShortLongMap newImmutableMapOf(
            short k1, long v1, short k2, long v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortLongMap newImmutableMapOf(
            short k1, long v1, short k2, long v2,
            short k3, long v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortLongMap newImmutableMapOf(
            short k1, long v1, short k2, long v2,
            short k3, long v3, short k4, long v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortLongMap newImmutableMapOf(
            short k1, long v1, short k2, long v2,
            short k3, long v3, short k4, long v4,
            short k5, long v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashShortLongMaps() {}
}

