/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ShortLongConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashShortLongMaps}
 *
 * @see HashShortLongMap
 * @see HashShortLongMaps#getDefaultFactory()
 */
public interface HashShortLongMapFactory extends ShortLongMapFactory
        , ShortHashFactory<HashShortLongMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashShortLongMapFactory withDefaultValue(long defaultValue);

    @Override
     HashShortLongMap newMutableMap();

    @Override
     HashShortLongMap newMutableMap(int expectedSize);

    


    @Override
     HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, int expectedSize);

    @Override
     HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3, int expectedSize);

    @Override
     HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, int expectedSize);

    @Override
     HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5, int expectedSize);

    

    
    @Override
     HashShortLongMap newMutableMap(Map<Short, Long> map);

    @Override
     HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2);

    @Override
     HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3);

    @Override
     HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4);

    @Override
     HashShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5);


    @Override
     HashShortLongMap newMutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier);

    @Override
     HashShortLongMap newMutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortLongMap newMutableMap(short[] keys, long[] values);

    @Override
     HashShortLongMap newMutableMap(short[] keys, long[] values,
            int expectedSize);

    @Override
     HashShortLongMap newMutableMap(
            Short[] keys, Long[] values);

    @Override
     HashShortLongMap newMutableMap(
            Short[] keys, Long[] values, int expectedSize);

    @Override
     HashShortLongMap newMutableMap(Iterable<Short> keys,
            Iterable<Long> values);

    @Override
     HashShortLongMap newMutableMap(Iterable<Short> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashShortLongMap newMutableMapOf(short k1, long v1);

    @Override
     HashShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2);

    @Override
     HashShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3);

    @Override
     HashShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4);

    @Override
     HashShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4, short k5, long v5);
    @Override
     HashShortLongMap newUpdatableMap();

    @Override
     HashShortLongMap newUpdatableMap(int expectedSize);

    


    @Override
     HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, int expectedSize);

    @Override
     HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3, int expectedSize);

    @Override
     HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, int expectedSize);

    @Override
     HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5, int expectedSize);

    

    
    @Override
     HashShortLongMap newUpdatableMap(Map<Short, Long> map);

    @Override
     HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2);

    @Override
     HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3);

    @Override
     HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4);

    @Override
     HashShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5);


    @Override
     HashShortLongMap newUpdatableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier);

    @Override
     HashShortLongMap newUpdatableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortLongMap newUpdatableMap(short[] keys, long[] values);

    @Override
     HashShortLongMap newUpdatableMap(short[] keys, long[] values,
            int expectedSize);

    @Override
     HashShortLongMap newUpdatableMap(
            Short[] keys, Long[] values);

    @Override
     HashShortLongMap newUpdatableMap(
            Short[] keys, Long[] values, int expectedSize);

    @Override
     HashShortLongMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Long> values);

    @Override
     HashShortLongMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashShortLongMap newUpdatableMapOf(short k1, long v1);

    @Override
     HashShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2);

    @Override
     HashShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3);

    @Override
     HashShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4);

    @Override
     HashShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4, short k5, long v5);

    


    @Override
     HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, int expectedSize);

    @Override
     HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3, int expectedSize);

    @Override
     HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, int expectedSize);

    @Override
     HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5, int expectedSize);

    

    
    @Override
     HashShortLongMap newImmutableMap(Map<Short, Long> map);

    @Override
     HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2);

    @Override
     HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3);

    @Override
     HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4);

    @Override
     HashShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5);


    @Override
     HashShortLongMap newImmutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier);

    @Override
     HashShortLongMap newImmutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortLongMap newImmutableMap(short[] keys, long[] values);

    @Override
     HashShortLongMap newImmutableMap(short[] keys, long[] values,
            int expectedSize);

    @Override
     HashShortLongMap newImmutableMap(
            Short[] keys, Long[] values);

    @Override
     HashShortLongMap newImmutableMap(
            Short[] keys, Long[] values, int expectedSize);

    @Override
     HashShortLongMap newImmutableMap(Iterable<Short> keys,
            Iterable<Long> values);

    @Override
     HashShortLongMap newImmutableMap(Iterable<Short> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashShortLongMap newImmutableMapOf(short k1, long v1);

    @Override
     HashShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2);

    @Override
     HashShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3);

    @Override
     HashShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4);

    @Override
     HashShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4, short k5, long v5);
}

