/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ShortIntConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashShortIntMap}s, and
 * the default {@link HashShortIntMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashShortIntMap
 */
public final class HashShortIntMaps {

    

    private static final ServiceLoader<HashShortIntMapFactory> LOADER =
            ServiceLoader.load(HashShortIntMapFactory.class);
    private static HashShortIntMapFactory defaultFactory = null;

    public static HashShortIntMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashShortIntMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashShortIntMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortIntMap newMutableMap(
            Map<Short, Integer> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortIntMap newMutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashShortIntMap newMutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortIntMap newMutableMap(
            short[] keys, int[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortIntMap newMutableMap(
            short[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortIntMap newMutableMap(
            Short[] keys, Integer[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortIntMap newMutableMap(
            Short[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortIntMap newMutableMap(Iterable<Short> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortIntMap newMutableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashShortIntMap newMutableMapOf(
            short k1, int v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashShortIntMap newMutableMapOf(
            short k1, int v1, short k2, int v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortIntMap newMutableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortIntMap newMutableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3, short k4, int v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortIntMap newMutableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3, short k4, int v4,
            short k5, int v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortIntMap newUpdatableMap(
            Map<Short, Integer> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortIntMap newUpdatableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashShortIntMap newUpdatableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortIntMap newUpdatableMap(
            short[] keys, int[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortIntMap newUpdatableMap(
            short[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortIntMap newUpdatableMap(
            Short[] keys, Integer[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortIntMap newUpdatableMap(
            Short[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortIntMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortIntMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashShortIntMap newUpdatableMapOf(
            short k1, int v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashShortIntMap newUpdatableMapOf(
            short k1, int v1, short k2, int v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortIntMap newUpdatableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortIntMap newUpdatableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3, short k4, int v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortIntMap newUpdatableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3, short k4, int v4,
            short k5, int v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortIntMap newImmutableMap(
            Map<Short, Integer> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortIntMap newImmutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashShortIntMap newImmutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortIntMap newImmutableMap(
            short[] keys, int[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortIntMap newImmutableMap(
            short[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortIntMap newImmutableMap(
            Short[] keys, Integer[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortIntMap newImmutableMap(
            Short[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortIntMap newImmutableMap(Iterable<Short> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortIntMap newImmutableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashShortIntMap newImmutableMapOf(
            short k1, int v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashShortIntMap newImmutableMapOf(
            short k1, int v1, short k2, int v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortIntMap newImmutableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortIntMap newImmutableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3, short k4, int v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortIntMap newImmutableMapOf(
            short k1, int v1, short k2, int v2,
            short k3, int v3, short k4, int v4,
            short k5, int v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashShortIntMaps() {}
}

