/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ShortIntConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashShortIntMaps}
 *
 * @see HashShortIntMap
 * @see HashShortIntMaps#getDefaultFactory()
 */
public interface HashShortIntMapFactory extends ShortIntMapFactory
        , ShortHashFactory<HashShortIntMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashShortIntMapFactory withDefaultValue(int defaultValue);

    @Override
     HashShortIntMap newMutableMap();

    @Override
     HashShortIntMap newMutableMap(int expectedSize);

    


    @Override
     HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize);

    @Override
     HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize);

    @Override
     HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize);

    @Override
     HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize);

    

    
    @Override
     HashShortIntMap newMutableMap(Map<Short, Integer> map);

    @Override
     HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2);

    @Override
     HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3);

    @Override
     HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4);

    @Override
     HashShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5);


    @Override
     HashShortIntMap newMutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier);

    @Override
     HashShortIntMap newMutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortIntMap newMutableMap(short[] keys, int[] values);

    @Override
     HashShortIntMap newMutableMap(short[] keys, int[] values,
            int expectedSize);

    @Override
     HashShortIntMap newMutableMap(
            Short[] keys, Integer[] values);

    @Override
     HashShortIntMap newMutableMap(
            Short[] keys, Integer[] values, int expectedSize);

    @Override
     HashShortIntMap newMutableMap(Iterable<Short> keys,
            Iterable<Integer> values);

    @Override
     HashShortIntMap newMutableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashShortIntMap newMutableMapOf(short k1, int v1);

    @Override
     HashShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2);

    @Override
     HashShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3);

    @Override
     HashShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4);

    @Override
     HashShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4, short k5, int v5);
    @Override
     HashShortIntMap newUpdatableMap();

    @Override
     HashShortIntMap newUpdatableMap(int expectedSize);

    


    @Override
     HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize);

    @Override
     HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize);

    @Override
     HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize);

    @Override
     HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize);

    

    
    @Override
     HashShortIntMap newUpdatableMap(Map<Short, Integer> map);

    @Override
     HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2);

    @Override
     HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3);

    @Override
     HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4);

    @Override
     HashShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5);


    @Override
     HashShortIntMap newUpdatableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier);

    @Override
     HashShortIntMap newUpdatableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortIntMap newUpdatableMap(short[] keys, int[] values);

    @Override
     HashShortIntMap newUpdatableMap(short[] keys, int[] values,
            int expectedSize);

    @Override
     HashShortIntMap newUpdatableMap(
            Short[] keys, Integer[] values);

    @Override
     HashShortIntMap newUpdatableMap(
            Short[] keys, Integer[] values, int expectedSize);

    @Override
     HashShortIntMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Integer> values);

    @Override
     HashShortIntMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashShortIntMap newUpdatableMapOf(short k1, int v1);

    @Override
     HashShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2);

    @Override
     HashShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3);

    @Override
     HashShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4);

    @Override
     HashShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4, short k5, int v5);

    


    @Override
     HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize);

    @Override
     HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize);

    @Override
     HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize);

    @Override
     HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize);

    

    
    @Override
     HashShortIntMap newImmutableMap(Map<Short, Integer> map);

    @Override
     HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2);

    @Override
     HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3);

    @Override
     HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4);

    @Override
     HashShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5);


    @Override
     HashShortIntMap newImmutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier);

    @Override
     HashShortIntMap newImmutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortIntMap newImmutableMap(short[] keys, int[] values);

    @Override
     HashShortIntMap newImmutableMap(short[] keys, int[] values,
            int expectedSize);

    @Override
     HashShortIntMap newImmutableMap(
            Short[] keys, Integer[] values);

    @Override
     HashShortIntMap newImmutableMap(
            Short[] keys, Integer[] values, int expectedSize);

    @Override
     HashShortIntMap newImmutableMap(Iterable<Short> keys,
            Iterable<Integer> values);

    @Override
     HashShortIntMap newImmutableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashShortIntMap newImmutableMapOf(short k1, int v1);

    @Override
     HashShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2);

    @Override
     HashShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3);

    @Override
     HashShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4);

    @Override
     HashShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4, short k5, int v5);
}

