/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ShortFloatConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashShortFloatMap}s, and
 * the default {@link HashShortFloatMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashShortFloatMap
 */
public final class HashShortFloatMaps {

    

    private static final ServiceLoader<HashShortFloatMapFactory> LOADER =
            ServiceLoader.load(HashShortFloatMapFactory.class);
    private static HashShortFloatMapFactory defaultFactory = null;

    public static HashShortFloatMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashShortFloatMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashShortFloatMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortFloatMap newMutableMap(
            Map<Short, Float> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortFloatMap newMutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashShortFloatMap newMutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortFloatMap newMutableMap(
            short[] keys, float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortFloatMap newMutableMap(
            short[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortFloatMap newMutableMap(
            Short[] keys, Float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortFloatMap newMutableMap(
            Short[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortFloatMap newMutableMap(Iterable<Short> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortFloatMap newMutableMap(Iterable<Short> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashShortFloatMap newMutableMapOf(
            short k1, float v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashShortFloatMap newMutableMapOf(
            short k1, float v1, short k2, float v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortFloatMap newMutableMapOf(
            short k1, float v1, short k2, float v2,
            short k3, float v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortFloatMap newMutableMapOf(
            short k1, float v1, short k2, float v2,
            short k3, float v3, short k4, float v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortFloatMap newMutableMapOf(
            short k1, float v1, short k2, float v2,
            short k3, float v3, short k4, float v4,
            short k5, float v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortFloatMap newUpdatableMap(
            Map<Short, Float> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashShortFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortFloatMap newUpdatableMap(
            short[] keys, float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortFloatMap newUpdatableMap(
            short[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortFloatMap newUpdatableMap(
            Short[] keys, Float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortFloatMap newUpdatableMap(
            Short[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortFloatMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortFloatMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashShortFloatMap newUpdatableMapOf(
            short k1, float v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashShortFloatMap newUpdatableMapOf(
            short k1, float v1, short k2, float v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortFloatMap newUpdatableMapOf(
            short k1, float v1, short k2, float v2,
            short k3, float v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortFloatMap newUpdatableMapOf(
            short k1, float v1, short k2, float v2,
            short k3, float v3, short k4, float v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortFloatMap newUpdatableMapOf(
            short k1, float v1, short k2, float v2,
            short k3, float v3, short k4, float v4,
            short k5, float v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortFloatMap newImmutableMap(
            Map<Short, Float> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortFloatMap newImmutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashShortFloatMap newImmutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortFloatMap newImmutableMap(
            short[] keys, float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortFloatMap newImmutableMap(
            short[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortFloatMap newImmutableMap(
            Short[] keys, Float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortFloatMap newImmutableMap(
            Short[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortFloatMap newImmutableMap(Iterable<Short> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortFloatMap newImmutableMap(Iterable<Short> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashShortFloatMap newImmutableMapOf(
            short k1, float v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashShortFloatMap newImmutableMapOf(
            short k1, float v1, short k2, float v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortFloatMap newImmutableMapOf(
            short k1, float v1, short k2, float v2,
            short k3, float v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortFloatMap newImmutableMapOf(
            short k1, float v1, short k2, float v2,
            short k3, float v3, short k4, float v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortFloatMap newImmutableMapOf(
            short k1, float v1, short k2, float v2,
            short k3, float v3, short k4, float v4,
            short k5, float v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashShortFloatMaps() {}
}

