/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ShortFloatConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashShortFloatMaps}
 *
 * @see HashShortFloatMap
 * @see HashShortFloatMaps#getDefaultFactory()
 */
public interface HashShortFloatMapFactory extends ShortFloatMapFactory
        , ShortHashFactory<HashShortFloatMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashShortFloatMapFactory withDefaultValue(float defaultValue);

    @Override
     HashShortFloatMap newMutableMap();

    @Override
     HashShortFloatMap newMutableMap(int expectedSize);

    


    @Override
     HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, int expectedSize);

    @Override
     HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3, int expectedSize);

    @Override
     HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, int expectedSize);

    @Override
     HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5, int expectedSize);

    

    
    @Override
     HashShortFloatMap newMutableMap(Map<Short, Float> map);

    @Override
     HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2);

    @Override
     HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3);

    @Override
     HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4);

    @Override
     HashShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5);


    @Override
     HashShortFloatMap newMutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier);

    @Override
     HashShortFloatMap newMutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortFloatMap newMutableMap(short[] keys, float[] values);

    @Override
     HashShortFloatMap newMutableMap(short[] keys, float[] values,
            int expectedSize);

    @Override
     HashShortFloatMap newMutableMap(
            Short[] keys, Float[] values);

    @Override
     HashShortFloatMap newMutableMap(
            Short[] keys, Float[] values, int expectedSize);

    @Override
     HashShortFloatMap newMutableMap(Iterable<Short> keys,
            Iterable<Float> values);

    @Override
     HashShortFloatMap newMutableMap(Iterable<Short> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashShortFloatMap newMutableMapOf(short k1, float v1);

    @Override
     HashShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2);

    @Override
     HashShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3);

    @Override
     HashShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4);

    @Override
     HashShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4, short k5, float v5);
    @Override
     HashShortFloatMap newUpdatableMap();

    @Override
     HashShortFloatMap newUpdatableMap(int expectedSize);

    


    @Override
     HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, int expectedSize);

    @Override
     HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3, int expectedSize);

    @Override
     HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, int expectedSize);

    @Override
     HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5, int expectedSize);

    

    
    @Override
     HashShortFloatMap newUpdatableMap(Map<Short, Float> map);

    @Override
     HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2);

    @Override
     HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3);

    @Override
     HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4);

    @Override
     HashShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5);


    @Override
     HashShortFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier);

    @Override
     HashShortFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortFloatMap newUpdatableMap(short[] keys, float[] values);

    @Override
     HashShortFloatMap newUpdatableMap(short[] keys, float[] values,
            int expectedSize);

    @Override
     HashShortFloatMap newUpdatableMap(
            Short[] keys, Float[] values);

    @Override
     HashShortFloatMap newUpdatableMap(
            Short[] keys, Float[] values, int expectedSize);

    @Override
     HashShortFloatMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Float> values);

    @Override
     HashShortFloatMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashShortFloatMap newUpdatableMapOf(short k1, float v1);

    @Override
     HashShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2);

    @Override
     HashShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3);

    @Override
     HashShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4);

    @Override
     HashShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4, short k5, float v5);

    


    @Override
     HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, int expectedSize);

    @Override
     HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3, int expectedSize);

    @Override
     HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, int expectedSize);

    @Override
     HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5, int expectedSize);

    

    
    @Override
     HashShortFloatMap newImmutableMap(Map<Short, Float> map);

    @Override
     HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2);

    @Override
     HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3);

    @Override
     HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4);

    @Override
     HashShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5);


    @Override
     HashShortFloatMap newImmutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier);

    @Override
     HashShortFloatMap newImmutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortFloatMap newImmutableMap(short[] keys, float[] values);

    @Override
     HashShortFloatMap newImmutableMap(short[] keys, float[] values,
            int expectedSize);

    @Override
     HashShortFloatMap newImmutableMap(
            Short[] keys, Float[] values);

    @Override
     HashShortFloatMap newImmutableMap(
            Short[] keys, Float[] values, int expectedSize);

    @Override
     HashShortFloatMap newImmutableMap(Iterable<Short> keys,
            Iterable<Float> values);

    @Override
     HashShortFloatMap newImmutableMap(Iterable<Short> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashShortFloatMap newImmutableMapOf(short k1, float v1);

    @Override
     HashShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2);

    @Override
     HashShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3);

    @Override
     HashShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4);

    @Override
     HashShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4, short k5, float v5);
}

