/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ShortDoubleConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashShortDoubleMap}s, and
 * the default {@link HashShortDoubleMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashShortDoubleMap
 */
public final class HashShortDoubleMaps {

    

    private static final ServiceLoader<HashShortDoubleMapFactory> LOADER =
            ServiceLoader.load(HashShortDoubleMapFactory.class);
    private static HashShortDoubleMapFactory defaultFactory = null;

    public static HashShortDoubleMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashShortDoubleMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashShortDoubleMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortDoubleMap newMutableMap(
            Map<Short, Double> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortDoubleMap newMutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashShortDoubleMap newMutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortDoubleMap newMutableMap(
            short[] keys, double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortDoubleMap newMutableMap(
            short[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortDoubleMap newMutableMap(
            Short[] keys, Double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortDoubleMap newMutableMap(
            Short[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortDoubleMap newMutableMap(Iterable<Short> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortDoubleMap newMutableMap(Iterable<Short> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashShortDoubleMap newMutableMapOf(
            short k1, double v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashShortDoubleMap newMutableMapOf(
            short k1, double v1, short k2, double v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortDoubleMap newMutableMapOf(
            short k1, double v1, short k2, double v2,
            short k3, double v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortDoubleMap newMutableMapOf(
            short k1, double v1, short k2, double v2,
            short k3, double v3, short k4, double v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortDoubleMap newMutableMapOf(
            short k1, double v1, short k2, double v2,
            short k3, double v3, short k4, double v4,
            short k5, double v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortDoubleMap newUpdatableMap(
            Map<Short, Double> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashShortDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortDoubleMap newUpdatableMap(
            short[] keys, double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortDoubleMap newUpdatableMap(
            short[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortDoubleMap newUpdatableMap(
            Short[] keys, Double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortDoubleMap newUpdatableMap(
            Short[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortDoubleMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortDoubleMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashShortDoubleMap newUpdatableMapOf(
            short k1, double v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashShortDoubleMap newUpdatableMapOf(
            short k1, double v1, short k2, double v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortDoubleMap newUpdatableMapOf(
            short k1, double v1, short k2, double v2,
            short k3, double v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortDoubleMap newUpdatableMapOf(
            short k1, double v1, short k2, double v2,
            short k3, double v3, short k4, double v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortDoubleMap newUpdatableMapOf(
            short k1, double v1, short k2, double v2,
            short k3, double v3, short k4, double v4,
            short k5, double v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortDoubleMap newImmutableMap(
            Map<Short, Double> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashShortDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortDoubleMap newImmutableMap(
            short[] keys, double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortDoubleMap newImmutableMap(
            short[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortDoubleMap newImmutableMap(
            Short[] keys, Double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortDoubleMap newImmutableMap(
            Short[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortDoubleMap newImmutableMap(Iterable<Short> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortDoubleMap newImmutableMap(Iterable<Short> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashShortDoubleMap newImmutableMapOf(
            short k1, double v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashShortDoubleMap newImmutableMapOf(
            short k1, double v1, short k2, double v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortDoubleMap newImmutableMapOf(
            short k1, double v1, short k2, double v2,
            short k3, double v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortDoubleMap newImmutableMapOf(
            short k1, double v1, short k2, double v2,
            short k3, double v3, short k4, double v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortDoubleMap newImmutableMapOf(
            short k1, double v1, short k2, double v2,
            short k3, double v3, short k4, double v4,
            short k5, double v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashShortDoubleMaps() {}
}

