/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ShortDoubleConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashShortDoubleMaps}
 *
 * @see HashShortDoubleMap
 * @see HashShortDoubleMaps#getDefaultFactory()
 */
public interface HashShortDoubleMapFactory extends ShortDoubleMapFactory
        , ShortHashFactory<HashShortDoubleMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashShortDoubleMapFactory withDefaultValue(double defaultValue);

    @Override
     HashShortDoubleMap newMutableMap();

    @Override
     HashShortDoubleMap newMutableMap(int expectedSize);

    


    @Override
     HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, int expectedSize);

    @Override
     HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3, int expectedSize);

    @Override
     HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, int expectedSize);

    @Override
     HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5, int expectedSize);

    

    
    @Override
     HashShortDoubleMap newMutableMap(Map<Short, Double> map);

    @Override
     HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2);

    @Override
     HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3);

    @Override
     HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4);

    @Override
     HashShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5);


    @Override
     HashShortDoubleMap newMutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier);

    @Override
     HashShortDoubleMap newMutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortDoubleMap newMutableMap(short[] keys, double[] values);

    @Override
     HashShortDoubleMap newMutableMap(short[] keys, double[] values,
            int expectedSize);

    @Override
     HashShortDoubleMap newMutableMap(
            Short[] keys, Double[] values);

    @Override
     HashShortDoubleMap newMutableMap(
            Short[] keys, Double[] values, int expectedSize);

    @Override
     HashShortDoubleMap newMutableMap(Iterable<Short> keys,
            Iterable<Double> values);

    @Override
     HashShortDoubleMap newMutableMap(Iterable<Short> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashShortDoubleMap newMutableMapOf(short k1, double v1);

    @Override
     HashShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2);

    @Override
     HashShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3);

    @Override
     HashShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4);

    @Override
     HashShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4, short k5, double v5);
    @Override
     HashShortDoubleMap newUpdatableMap();

    @Override
     HashShortDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
     HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, int expectedSize);

    @Override
     HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3, int expectedSize);

    @Override
     HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, int expectedSize);

    @Override
     HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5, int expectedSize);

    

    
    @Override
     HashShortDoubleMap newUpdatableMap(Map<Short, Double> map);

    @Override
     HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2);

    @Override
     HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3);

    @Override
     HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4);

    @Override
     HashShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5);


    @Override
     HashShortDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier);

    @Override
     HashShortDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortDoubleMap newUpdatableMap(short[] keys, double[] values);

    @Override
     HashShortDoubleMap newUpdatableMap(short[] keys, double[] values,
            int expectedSize);

    @Override
     HashShortDoubleMap newUpdatableMap(
            Short[] keys, Double[] values);

    @Override
     HashShortDoubleMap newUpdatableMap(
            Short[] keys, Double[] values, int expectedSize);

    @Override
     HashShortDoubleMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Double> values);

    @Override
     HashShortDoubleMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1);

    @Override
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2);

    @Override
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3);

    @Override
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4);

    @Override
     HashShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4, short k5, double v5);

    


    @Override
     HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, int expectedSize);

    @Override
     HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3, int expectedSize);

    @Override
     HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, int expectedSize);

    @Override
     HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5, int expectedSize);

    

    
    @Override
     HashShortDoubleMap newImmutableMap(Map<Short, Double> map);

    @Override
     HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2);

    @Override
     HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3);

    @Override
     HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4);

    @Override
     HashShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5);


    @Override
     HashShortDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier);

    @Override
     HashShortDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortDoubleMap newImmutableMap(short[] keys, double[] values);

    @Override
     HashShortDoubleMap newImmutableMap(short[] keys, double[] values,
            int expectedSize);

    @Override
     HashShortDoubleMap newImmutableMap(
            Short[] keys, Double[] values);

    @Override
     HashShortDoubleMap newImmutableMap(
            Short[] keys, Double[] values, int expectedSize);

    @Override
     HashShortDoubleMap newImmutableMap(Iterable<Short> keys,
            Iterable<Double> values);

    @Override
     HashShortDoubleMap newImmutableMap(Iterable<Short> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashShortDoubleMap newImmutableMapOf(short k1, double v1);

    @Override
     HashShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2);

    @Override
     HashShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3);

    @Override
     HashShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4);

    @Override
     HashShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4, short k5, double v5);
}

