/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ShortCharConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashShortCharMap}s, and
 * the default {@link HashShortCharMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashShortCharMap
 */
public final class HashShortCharMaps {

    

    private static final ServiceLoader<HashShortCharMapFactory> LOADER =
            ServiceLoader.load(HashShortCharMapFactory.class);
    private static HashShortCharMapFactory defaultFactory = null;

    public static HashShortCharMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashShortCharMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashShortCharMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortCharMap newMutableMap(
            Map<Short, Character> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortCharMap newMutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashShortCharMap newMutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortCharMap newMutableMap(
            short[] keys, char[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortCharMap newMutableMap(
            short[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortCharMap newMutableMap(
            Short[] keys, Character[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortCharMap newMutableMap(
            Short[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortCharMap newMutableMap(Iterable<Short> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortCharMap newMutableMap(Iterable<Short> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashShortCharMap newMutableMapOf(
            short k1, char v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashShortCharMap newMutableMapOf(
            short k1, char v1, short k2, char v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortCharMap newMutableMapOf(
            short k1, char v1, short k2, char v2,
            short k3, char v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortCharMap newMutableMapOf(
            short k1, char v1, short k2, char v2,
            short k3, char v3, short k4, char v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortCharMap newMutableMapOf(
            short k1, char v1, short k2, char v2,
            short k3, char v3, short k4, char v4,
            short k5, char v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortCharMap newUpdatableMap(
            Map<Short, Character> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortCharMap newUpdatableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashShortCharMap newUpdatableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortCharMap newUpdatableMap(
            short[] keys, char[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortCharMap newUpdatableMap(
            short[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortCharMap newUpdatableMap(
            Short[] keys, Character[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortCharMap newUpdatableMap(
            Short[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortCharMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortCharMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashShortCharMap newUpdatableMapOf(
            short k1, char v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashShortCharMap newUpdatableMapOf(
            short k1, char v1, short k2, char v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortCharMap newUpdatableMapOf(
            short k1, char v1, short k2, char v2,
            short k3, char v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortCharMap newUpdatableMapOf(
            short k1, char v1, short k2, char v2,
            short k3, char v3, short k4, char v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortCharMap newUpdatableMapOf(
            short k1, char v1, short k2, char v2,
            short k3, char v3, short k4, char v4,
            short k5, char v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortCharMap newImmutableMap(
            Map<Short, Character> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortCharMap newImmutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashShortCharMap newImmutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortCharMap newImmutableMap(
            short[] keys, char[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortCharMap newImmutableMap(
            short[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortCharMap newImmutableMap(
            Short[] keys, Character[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortCharMap newImmutableMap(
            Short[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortCharMap newImmutableMap(Iterable<Short> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortCharMap newImmutableMap(Iterable<Short> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashShortCharMap newImmutableMapOf(
            short k1, char v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashShortCharMap newImmutableMapOf(
            short k1, char v1, short k2, char v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortCharMap newImmutableMapOf(
            short k1, char v1, short k2, char v2,
            short k3, char v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortCharMap newImmutableMapOf(
            short k1, char v1, short k2, char v2,
            short k3, char v3, short k4, char v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortCharMap newImmutableMapOf(
            short k1, char v1, short k2, char v2,
            short k3, char v3, short k4, char v4,
            short k5, char v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashShortCharMaps() {}
}

