/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ShortCharConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashShortCharMaps}
 *
 * @see HashShortCharMap
 * @see HashShortCharMaps#getDefaultFactory()
 */
public interface HashShortCharMapFactory extends ShortCharMapFactory
        , ShortHashFactory<HashShortCharMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashShortCharMapFactory withDefaultValue(char defaultValue);

    @Override
     HashShortCharMap newMutableMap();

    @Override
     HashShortCharMap newMutableMap(int expectedSize);

    


    @Override
     HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, int expectedSize);

    @Override
     HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3, int expectedSize);

    @Override
     HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, int expectedSize);

    @Override
     HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5, int expectedSize);

    

    
    @Override
     HashShortCharMap newMutableMap(Map<Short, Character> map);

    @Override
     HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2);

    @Override
     HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3);

    @Override
     HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4);

    @Override
     HashShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5);


    @Override
     HashShortCharMap newMutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier);

    @Override
     HashShortCharMap newMutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortCharMap newMutableMap(short[] keys, char[] values);

    @Override
     HashShortCharMap newMutableMap(short[] keys, char[] values,
            int expectedSize);

    @Override
     HashShortCharMap newMutableMap(
            Short[] keys, Character[] values);

    @Override
     HashShortCharMap newMutableMap(
            Short[] keys, Character[] values, int expectedSize);

    @Override
     HashShortCharMap newMutableMap(Iterable<Short> keys,
            Iterable<Character> values);

    @Override
     HashShortCharMap newMutableMap(Iterable<Short> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashShortCharMap newMutableMapOf(short k1, char v1);

    @Override
     HashShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2);

    @Override
     HashShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3);

    @Override
     HashShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4);

    @Override
     HashShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4, short k5, char v5);
    @Override
     HashShortCharMap newUpdatableMap();

    @Override
     HashShortCharMap newUpdatableMap(int expectedSize);

    


    @Override
     HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, int expectedSize);

    @Override
     HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3, int expectedSize);

    @Override
     HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, int expectedSize);

    @Override
     HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5, int expectedSize);

    

    
    @Override
     HashShortCharMap newUpdatableMap(Map<Short, Character> map);

    @Override
     HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2);

    @Override
     HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3);

    @Override
     HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4);

    @Override
     HashShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5);


    @Override
     HashShortCharMap newUpdatableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier);

    @Override
     HashShortCharMap newUpdatableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortCharMap newUpdatableMap(short[] keys, char[] values);

    @Override
     HashShortCharMap newUpdatableMap(short[] keys, char[] values,
            int expectedSize);

    @Override
     HashShortCharMap newUpdatableMap(
            Short[] keys, Character[] values);

    @Override
     HashShortCharMap newUpdatableMap(
            Short[] keys, Character[] values, int expectedSize);

    @Override
     HashShortCharMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Character> values);

    @Override
     HashShortCharMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashShortCharMap newUpdatableMapOf(short k1, char v1);

    @Override
     HashShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2);

    @Override
     HashShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3);

    @Override
     HashShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4);

    @Override
     HashShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4, short k5, char v5);

    


    @Override
     HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, int expectedSize);

    @Override
     HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3, int expectedSize);

    @Override
     HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, int expectedSize);

    @Override
     HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5, int expectedSize);

    

    
    @Override
     HashShortCharMap newImmutableMap(Map<Short, Character> map);

    @Override
     HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2);

    @Override
     HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3);

    @Override
     HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4);

    @Override
     HashShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5);


    @Override
     HashShortCharMap newImmutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier);

    @Override
     HashShortCharMap newImmutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortCharMap newImmutableMap(short[] keys, char[] values);

    @Override
     HashShortCharMap newImmutableMap(short[] keys, char[] values,
            int expectedSize);

    @Override
     HashShortCharMap newImmutableMap(
            Short[] keys, Character[] values);

    @Override
     HashShortCharMap newImmutableMap(
            Short[] keys, Character[] values, int expectedSize);

    @Override
     HashShortCharMap newImmutableMap(Iterable<Short> keys,
            Iterable<Character> values);

    @Override
     HashShortCharMap newImmutableMap(Iterable<Short> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashShortCharMap newImmutableMapOf(short k1, char v1);

    @Override
     HashShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2);

    @Override
     HashShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3);

    @Override
     HashShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4);

    @Override
     HashShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4, short k5, char v5);
}

