/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ShortByteConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashShortByteMap}s, and
 * the default {@link HashShortByteMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashShortByteMap
 */
public final class HashShortByteMaps {

    

    private static final ServiceLoader<HashShortByteMapFactory> LOADER =
            ServiceLoader.load(HashShortByteMapFactory.class);
    private static HashShortByteMapFactory defaultFactory = null;

    public static HashShortByteMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashShortByteMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashShortByteMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortByteMap newMutableMap(
            Map<Short, Byte> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortByteMap newMutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashShortByteMap newMutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortByteMap newMutableMap(
            short[] keys, byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortByteMap newMutableMap(
            short[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortByteMap newMutableMap(
            Short[] keys, Byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortByteMap newMutableMap(
            Short[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashShortByteMap newMutableMap(Iterable<Short> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashShortByteMap newMutableMap(Iterable<Short> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashShortByteMap newMutableMapOf(
            short k1, byte v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashShortByteMap newMutableMapOf(
            short k1, byte v1, short k2, byte v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortByteMap newMutableMapOf(
            short k1, byte v1, short k2, byte v2,
            short k3, byte v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortByteMap newMutableMapOf(
            short k1, byte v1, short k2, byte v2,
            short k3, byte v3, short k4, byte v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortByteMap newMutableMapOf(
            short k1, byte v1, short k2, byte v2,
            short k3, byte v3, short k4, byte v4,
            short k5, byte v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortByteMap newUpdatableMap(
            Map<Short, Byte> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortByteMap newUpdatableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashShortByteMap newUpdatableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortByteMap newUpdatableMap(
            short[] keys, byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortByteMap newUpdatableMap(
            short[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortByteMap newUpdatableMap(
            Short[] keys, Byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortByteMap newUpdatableMap(
            Short[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashShortByteMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashShortByteMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashShortByteMap newUpdatableMapOf(
            short k1, byte v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashShortByteMap newUpdatableMapOf(
            short k1, byte v1, short k2, byte v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortByteMap newUpdatableMapOf(
            short k1, byte v1, short k2, byte v2,
            short k3, byte v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortByteMap newUpdatableMapOf(
            short k1, byte v1, short k2, byte v2,
            short k3, byte v3, short k4, byte v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortByteMap newUpdatableMapOf(
            short k1, byte v1, short k2, byte v2,
            short k3, byte v3, short k4, byte v4,
            short k5, byte v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashShortByteMap newImmutableMap(
            Map<Short, Byte> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashShortByteMap newImmutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashShortByteMap newImmutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashShortByteMap newImmutableMap(
            short[] keys, byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortByteMap newImmutableMap(
            short[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortByteMap newImmutableMap(
            Short[] keys, Byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortByteMap newImmutableMap(
            Short[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashShortByteMap newImmutableMap(Iterable<Short> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashShortByteMap newImmutableMap(Iterable<Short> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashShortByteMap newImmutableMapOf(
            short k1, byte v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashShortByteMap newImmutableMapOf(
            short k1, byte v1, short k2, byte v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashShortByteMap newImmutableMapOf(
            short k1, byte v1, short k2, byte v2,
            short k3, byte v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashShortByteMap newImmutableMapOf(
            short k1, byte v1, short k2, byte v2,
            short k3, byte v3, short k4, byte v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashShortByteMap newImmutableMapOf(
            short k1, byte v1, short k2, byte v2,
            short k3, byte v3, short k4, byte v4,
            short k5, byte v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashShortByteMaps() {}
}

