/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ShortByteConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashShortByteMaps}
 *
 * @see HashShortByteMap
 * @see HashShortByteMaps#getDefaultFactory()
 */
public interface HashShortByteMapFactory extends ShortByteMapFactory
        , ShortHashFactory<HashShortByteMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashShortByteMapFactory withDefaultValue(byte defaultValue);

    @Override
     HashShortByteMap newMutableMap();

    @Override
     HashShortByteMap newMutableMap(int expectedSize);

    


    @Override
     HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, int expectedSize);

    @Override
     HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3, int expectedSize);

    @Override
     HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, int expectedSize);

    @Override
     HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5, int expectedSize);

    

    
    @Override
     HashShortByteMap newMutableMap(Map<Short, Byte> map);

    @Override
     HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2);

    @Override
     HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3);

    @Override
     HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4);

    @Override
     HashShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5);


    @Override
     HashShortByteMap newMutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier);

    @Override
     HashShortByteMap newMutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortByteMap newMutableMap(short[] keys, byte[] values);

    @Override
     HashShortByteMap newMutableMap(short[] keys, byte[] values,
            int expectedSize);

    @Override
     HashShortByteMap newMutableMap(
            Short[] keys, Byte[] values);

    @Override
     HashShortByteMap newMutableMap(
            Short[] keys, Byte[] values, int expectedSize);

    @Override
     HashShortByteMap newMutableMap(Iterable<Short> keys,
            Iterable<Byte> values);

    @Override
     HashShortByteMap newMutableMap(Iterable<Short> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashShortByteMap newMutableMapOf(short k1, byte v1);

    @Override
     HashShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2);

    @Override
     HashShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3);

    @Override
     HashShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4);

    @Override
     HashShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4, short k5, byte v5);
    @Override
     HashShortByteMap newUpdatableMap();

    @Override
     HashShortByteMap newUpdatableMap(int expectedSize);

    


    @Override
     HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, int expectedSize);

    @Override
     HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3, int expectedSize);

    @Override
     HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, int expectedSize);

    @Override
     HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5, int expectedSize);

    

    
    @Override
     HashShortByteMap newUpdatableMap(Map<Short, Byte> map);

    @Override
     HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2);

    @Override
     HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3);

    @Override
     HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4);

    @Override
     HashShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5);


    @Override
     HashShortByteMap newUpdatableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier);

    @Override
     HashShortByteMap newUpdatableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortByteMap newUpdatableMap(short[] keys, byte[] values);

    @Override
     HashShortByteMap newUpdatableMap(short[] keys, byte[] values,
            int expectedSize);

    @Override
     HashShortByteMap newUpdatableMap(
            Short[] keys, Byte[] values);

    @Override
     HashShortByteMap newUpdatableMap(
            Short[] keys, Byte[] values, int expectedSize);

    @Override
     HashShortByteMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Byte> values);

    @Override
     HashShortByteMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashShortByteMap newUpdatableMapOf(short k1, byte v1);

    @Override
     HashShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2);

    @Override
     HashShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3);

    @Override
     HashShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4);

    @Override
     HashShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4, short k5, byte v5);

    


    @Override
     HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, int expectedSize);

    @Override
     HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3, int expectedSize);

    @Override
     HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, int expectedSize);

    @Override
     HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5, int expectedSize);

    

    
    @Override
     HashShortByteMap newImmutableMap(Map<Short, Byte> map);

    @Override
     HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2);

    @Override
     HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3);

    @Override
     HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4);

    @Override
     HashShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5);


    @Override
     HashShortByteMap newImmutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier);

    @Override
     HashShortByteMap newImmutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashShortByteMap newImmutableMap(short[] keys, byte[] values);

    @Override
     HashShortByteMap newImmutableMap(short[] keys, byte[] values,
            int expectedSize);

    @Override
     HashShortByteMap newImmutableMap(
            Short[] keys, Byte[] values);

    @Override
     HashShortByteMap newImmutableMap(
            Short[] keys, Byte[] values, int expectedSize);

    @Override
     HashShortByteMap newImmutableMap(Iterable<Short> keys,
            Iterable<Byte> values);

    @Override
     HashShortByteMap newImmutableMap(Iterable<Short> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashShortByteMap newImmutableMapOf(short k1, byte v1);

    @Override
     HashShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2);

    @Override
     HashShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3);

    @Override
     HashShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4);

    @Override
     HashShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4, short k5, byte v5);
}

