/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ObjShortConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashObjShortMap}s, and
 * the default {@link HashObjShortMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashObjShortMap
 */
public final class HashObjShortMaps {

    

    private static final ServiceLoader<HashObjShortMapFactory> LOADER =
            ServiceLoader.load(HashObjShortMapFactory.class);
    private static HashObjShortMapFactory<Object> defaultFactory = null;

    public static HashObjShortMapFactory<Object> getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static <K> HashObjShortMap<K> newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static <K> HashObjShortMap<K> newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K> HashObjShortMap<K> newMutableMap(
            Map<? extends K, Short> map, int expectedSize) {
        return getDefaultFactory().newMutableMap(map, expectedSize);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4, Map<? extends K, Short> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K> HashObjShortMap<K> newMutableMap(
            Map<? extends K, Short> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4, Map<? extends K, Short> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static <K> HashObjShortMap<K> newMutableMap(
            net.openhft.function.Consumer<ObjShortConsumer<K>> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static <K> HashObjShortMap<K> newMutableMap(
            net.openhft.function.Consumer<ObjShortConsumer<K>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static <K> HashObjShortMap<K> newMutableMap(
            K[] keys, short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K> HashObjShortMap<K> newMutableMap(
            K[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjShortMap<K> newMutableMap(
            K[] keys, Short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K> HashObjShortMap<K> newMutableMap(
            K[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Iterable<? extends K> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K> HashObjShortMap<K> newMutableMap(Iterable<? extends K> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static <K> HashObjShortMap<K> newMutableMapOf(
            K k1, short v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static <K> HashObjShortMap<K> newMutableMapOf(
            K k1, short v1, K k2, short v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static <K> HashObjShortMap<K> newMutableMapOf(
            K k1, short v1, K k2, short v2,
            K k3, short v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K> HashObjShortMap<K> newMutableMapOf(
            K k1, short v1, K k2, short v2,
            K k3, short v3, K k4, short v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K> HashObjShortMap<K> newMutableMapOf(
            K k1, short v1, K k2, short v2,
            K k3, short v3, K k4, short v4,
            K k5, short v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K> HashObjShortMap<K> newUpdatableMap(
            Map<? extends K, Short> map, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map, expectedSize);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4, Map<? extends K, Short> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K> HashObjShortMap<K> newUpdatableMap(
            Map<? extends K, Short> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4, Map<? extends K, Short> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static <K> HashObjShortMap<K> newUpdatableMap(
            net.openhft.function.Consumer<ObjShortConsumer<K>> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(
            net.openhft.function.Consumer<ObjShortConsumer<K>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(
            K[] keys, short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(
            K[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(
            K[] keys, Short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(
            K[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Iterable<? extends K> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K> HashObjShortMap<K> newUpdatableMap(Iterable<? extends K> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static <K> HashObjShortMap<K> newUpdatableMapOf(
            K k1, short v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static <K> HashObjShortMap<K> newUpdatableMapOf(
            K k1, short v1, K k2, short v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static <K> HashObjShortMap<K> newUpdatableMapOf(
            K k1, short v1, K k2, short v2,
            K k3, short v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K> HashObjShortMap<K> newUpdatableMapOf(
            K k1, short v1, K k2, short v2,
            K k3, short v3, K k4, short v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K> HashObjShortMap<K> newUpdatableMapOf(
            K k1, short v1, K k2, short v2,
            K k3, short v3, K k4, short v4,
            K k5, short v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K> HashObjShortMap<K> newImmutableMap(
            Map<? extends K, Short> map, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map, expectedSize);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4, Map<? extends K, Short> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K> HashObjShortMap<K> newImmutableMap(
            Map<? extends K, Short> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Map<? extends K, Short> map1,
            Map<? extends K, Short> map2, Map<? extends K, Short> map3,
            Map<? extends K, Short> map4, Map<? extends K, Short> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static <K> HashObjShortMap<K> newImmutableMap(
            net.openhft.function.Consumer<ObjShortConsumer<K>> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(
            net.openhft.function.Consumer<ObjShortConsumer<K>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(
            K[] keys, short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(
            K[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(
            K[] keys, Short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(
            K[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Iterable<? extends K> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K> HashObjShortMap<K> newImmutableMap(Iterable<? extends K> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static <K> HashObjShortMap<K> newImmutableMapOf(
            K k1, short v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static <K> HashObjShortMap<K> newImmutableMapOf(
            K k1, short v1, K k2, short v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static <K> HashObjShortMap<K> newImmutableMapOf(
            K k1, short v1, K k2, short v2,
            K k3, short v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K> HashObjShortMap<K> newImmutableMapOf(
            K k1, short v1, K k2, short v2,
            K k3, short v3, K k4, short v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K> HashObjShortMap<K> newImmutableMapOf(
            K k1, short v1, K k2, short v2,
            K k3, short v3, K k4, short v4,
            K k5, short v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashObjShortMaps() {}
}

